% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{row_paths}
\alias{row_paths}
\alias{col_paths}
\title{Get a list of table row/column paths}
\usage{
row_paths(x)

col_paths(x)
}
\arguments{
\item{x}{(\code{VTableTree})\cr an \code{rtable} object.}
}
\value{
A list of paths to each row/column within \code{x}.
}
\description{
Get a list of table row/column paths
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("SEX", "AGE"))

tbl <- build_table(lyt, ex_adsl)
tbl

row_paths(tbl)
col_paths(tbl)

cell_values(tbl, c("AGE", "Mean"), c("ARM", "B: Placebo"))

}
\seealso{
\code{\link[=cell_values]{cell_values()}}, \code{\link{fnotes_at_path<-}}, \code{\link[=row_paths_summary]{row_paths_summary()}}, \code{\link[=col_paths_summary]{col_paths_summary()}}
}
