% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_afun_utils.R
\name{in_rows}
\alias{in_rows}
\title{Create multiple rows in analysis or summary functions}
\usage{
in_rows(
  ...,
  .list = NULL,
  .names = NULL,
  .labels = NULL,
  .formats = NULL,
  .indent_mods = NULL,
  .cell_footnotes = list(NULL),
  .row_footnotes = list(NULL),
  .aligns = NULL,
  .format_na_strs = NULL,
  .stat_names = list(NULL)
)
}
\arguments{
\item{...}{single row defining expressions.}

\item{.list}{(\code{list})\cr list cell content (usually \code{rcells}). The \code{.list} is concatenated to \code{...}.}

\item{.names}{(\code{character} or \code{NULL})\cr names of the returned list/structure.}

\item{.labels}{(\code{character} or \code{NULL})\cr labels for the defined rows.}

\item{.formats}{(\code{character} or \code{NULL})\cr formats for the values.}

\item{.indent_mods}{(\code{integer} or \code{NULL})\cr indent modifications for the defined rows.}

\item{.cell_footnotes}{(\code{list})\cr referential footnote messages to be associated by name with \emph{cells}.}

\item{.row_footnotes}{(\code{list})\cr referential footnotes messages to be associated by name with \emph{rows}.}

\item{.aligns}{(\code{character} or \code{NULL})\cr alignments for the cells. Standard for \code{NULL} is \code{"center"}.
See \code{\link[formatters:list_formats]{formatters::list_valid_aligns()}} for currently supported alignments.}

\item{.format_na_strs}{(\code{character} or \code{NULL})\cr NA strings for the cells.}

\item{.stat_names}{(\code{list})\cr names for the statistics in the cells.
It can be a vector of values. If \code{list(NULL)}, statistic names are not specified and will
appear as \code{NA}.}
}
\value{
A \code{RowsVerticalSection} object (or \code{NULL}). The details of this object should be considered an
internal implementation detail.
}
\description{
Define the cells that get placed into multiple rows in \code{afun}.
}
\note{
In post-processing, referential footnotes can also be added using row and column
paths with \code{\link{fnotes_at_path<-}}.
}
\examples{
in_rows(1, 2, 3, .names = c("a", "b", "c"))
in_rows(1, 2, 3, .labels = c("a", "b", "c"))
in_rows(1, 2, 3, .names = c("a", "b", "c"), .labels = c("AAA", "BBB", "CCC"))
in_rows(
  .list = list(a = c(NA, NA)),
  .formats = "xx - xx",
  .format_na_strs = list(c("asda", "lkjklj"))
)
in_rows(.list = list(a = c(NA, NA)), .format_na_strs = c("asda", "lkjklj"))

in_rows(.list = list(a = 1, b = 2, c = 3))
in_rows(1, 2, .list = list(3), .names = c("a", "b", "c"))

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", afun = function(x) {
    in_rows(
      "Mean (sd)" = rcell(c(mean(x), sd(x)), format = "xx.xx (xx.xx)"),
      "Range" = rcell(range(x), format = "xx.xx - xx.xx")
    )
  })

tbl <- build_table(lyt, ex_adsl)
tbl

}
\seealso{
\code{\link[=analyze]{analyze()}}
}
