% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocker-R6-class.R
\name{rocker-R6-class}
\alias{rocker-R6-class}
\alias{rocker}
\title{'rocker' Database Interface R6 Class}
\format{
\link[R6:R6Class]{R6Class}
}
\description{
\link[R6:R6-package]{R6} class interface for handling database connections using \link[DBI:DBI-package]{DBI} package as backend. The class allows handling of connections to e.g. PostgreSQL, MariaDB and SQLite.
}
\examples{
# New database handling object
db <- rocker::newDB()
# Setup SQLite database
db$setupSQLite()
# Open connection
db$connect()
# Write table
db$writeTable("mtcars", mtcars)
# Get query
output <- db$getQuery("SELECT * FROM mtcars;")
# Close connection
db$disconnect()
# Reset database handling object
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupDriver`
## ------------------------------------------------

db <- rocker::newDB()
db$setupDriver(
  drv = RSQLite::SQLite(),
  dbname = ":memory:"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupPostgreSQL`
## ------------------------------------------------

db <- rocker::newDB()
db$setupPostgreSQL(
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupMariaDB`
## ------------------------------------------------

db <- rocker::newDB()
db$setupMariaDB(
  host = "127.0.0.1", port = "3306", dbname = "mydb",
  user = "root", password = "password"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupSQLite`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite(
  dbname = ":memory:"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$unloadDriver`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$canConnect`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$canConnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$connect`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$disconnect`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$sendQuery`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getQuery`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$getQuery("SELECT * FROM mtcars;")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$sendStatement`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$execute`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$execute("DELETE FROM mtcars WHERE gear = 3;")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$fetch`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$hasCompleted`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch(5)
db$hasCompleted()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getRowsAffected`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$getRowsAffected()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getRowCount`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$getRowCount()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$columnInfo`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$columnInfo()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getStatement`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getStatement()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$clearResult`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$begin`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$commit`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$rollback`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$rollback()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getInfoDrv`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$getInfoDrv()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getInfoCon`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$getInfoCon()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getInfoRes`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getInfoRes()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$isValidDrv`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$isValidDrv()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$isValidCon`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$isValidCon()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$isValidRes`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$isValidRes()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$validateCon`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$validateCon()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$createTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$appendTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$appendTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$writeTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$readTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$readTable("mtcars")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$removeTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$removeTable("mtcars")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$existsTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$existsTable("mtcars")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$listFields`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listFields("mtcars")
db$disconnect()

## ------------------------------------------------
## Method `rocker$listObjects`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listObjects()
db$disconnect()

## ------------------------------------------------
## Method `rocker$listTables`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listTables()
db$disconnect()
}
\seealso{
Other rocker: 
\code{\link{newDB}()},
\code{\link{rocker-README}},
\code{\link{rocker-S3-functions}},
\code{\link{rocker-package}}
}
\concept{rocker}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.drv}}{Read only \link[DBI:DBIDriver-class]{DBI::DBIDriver-class} object or NULL.
It is recommended not to use this object!
For advanced user, object can be used for direct execution of functions from DBI package.}

\item{\code{.con}}{Read only \link[DBI:DBIConnection-class]{DBI::DBIConnection-class} object or NULL.
It is recommended not to use this object!
For advanced user, object can be used for direct execution of functions from DBI package.}

\item{\code{.res}}{Read only \link[DBI:DBIResult-class]{DBI::DBIResult-class} object or NULL.
It is recommended not to use this object!
For advanced user, object can be used for direct execution of functions from DBI package.}

\item{\code{transaction}}{Read only TRUE or FALSE.
Information on pending transaction.}

\item{\code{info}}{Read only driver package and connection parameter information list.}

\item{\code{verbose}}{TRUE or FALSE. Switch text output on / off.}

\item{\code{id}}{Optional object ID/name}

\item{\code{validateQuery}}{SQL statement used in validateCon}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rocker-new}{\code{rocker$new()}}
\item \href{#method-rocker-print}{\code{rocker$print()}}
\item \href{#method-rocker-setupDriver}{\code{rocker$setupDriver()}}
\item \href{#method-rocker-setupPostgreSQL}{\code{rocker$setupPostgreSQL()}}
\item \href{#method-rocker-setupMariaDB}{\code{rocker$setupMariaDB()}}
\item \href{#method-rocker-setupSQLite}{\code{rocker$setupSQLite()}}
\item \href{#method-rocker-unloadDriver}{\code{rocker$unloadDriver()}}
\item \href{#method-rocker-canConnect}{\code{rocker$canConnect()}}
\item \href{#method-rocker-connect}{\code{rocker$connect()}}
\item \href{#method-rocker-disconnect}{\code{rocker$disconnect()}}
\item \href{#method-rocker-sendQuery}{\code{rocker$sendQuery()}}
\item \href{#method-rocker-getQuery}{\code{rocker$getQuery()}}
\item \href{#method-rocker-sendStatement}{\code{rocker$sendStatement()}}
\item \href{#method-rocker-execute}{\code{rocker$execute()}}
\item \href{#method-rocker-fetch}{\code{rocker$fetch()}}
\item \href{#method-rocker-hasCompleted}{\code{rocker$hasCompleted()}}
\item \href{#method-rocker-getRowsAffected}{\code{rocker$getRowsAffected()}}
\item \href{#method-rocker-getRowCount}{\code{rocker$getRowCount()}}
\item \href{#method-rocker-columnInfo}{\code{rocker$columnInfo()}}
\item \href{#method-rocker-getStatement}{\code{rocker$getStatement()}}
\item \href{#method-rocker-clearResult}{\code{rocker$clearResult()}}
\item \href{#method-rocker-begin}{\code{rocker$begin()}}
\item \href{#method-rocker-commit}{\code{rocker$commit()}}
\item \href{#method-rocker-rollback}{\code{rocker$rollback()}}
\item \href{#method-rocker-getInfoDrv}{\code{rocker$getInfoDrv()}}
\item \href{#method-rocker-getInfoCon}{\code{rocker$getInfoCon()}}
\item \href{#method-rocker-getInfoRes}{\code{rocker$getInfoRes()}}
\item \href{#method-rocker-isValidDrv}{\code{rocker$isValidDrv()}}
\item \href{#method-rocker-isValidCon}{\code{rocker$isValidCon()}}
\item \href{#method-rocker-isValidRes}{\code{rocker$isValidRes()}}
\item \href{#method-rocker-validateCon}{\code{rocker$validateCon()}}
\item \href{#method-rocker-createTable}{\code{rocker$createTable()}}
\item \href{#method-rocker-appendTable}{\code{rocker$appendTable()}}
\item \href{#method-rocker-writeTable}{\code{rocker$writeTable()}}
\item \href{#method-rocker-readTable}{\code{rocker$readTable()}}
\item \href{#method-rocker-removeTable}{\code{rocker$removeTable()}}
\item \href{#method-rocker-existsTable}{\code{rocker$existsTable()}}
\item \href{#method-rocker-listFields}{\code{rocker$listFields()}}
\item \href{#method-rocker-listObjects}{\code{rocker$listObjects()}}
\item \href{#method-rocker-listTables}{\code{rocker$listTables()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-new"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-new}{}}}
\subsection{Method \code{new()}}{
Generate new instance of class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$new(verbose = TRUE, id = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{TRUE or FALSE. Switch text output on / off.}

\item{\code{id}}{Optional object ID/name}

\item{\code{...}}{Not used yet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New instance of class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-print"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-print}{}}}
\subsection{Method \code{print()}}{
Print object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisible self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-setupDriver"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-setupDriver}{}}}
\subsection{Method \code{setupDriver()}}{
Setup database driver and define connection parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupDriver(drv, protect = c("password", "user"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drv}}{Driver object from suitable package e.g. \code{\link[RPostgres:Postgres]{RPostgres::Postgres()}}, \code{\link[RMariaDB:MariaDBDriver-class]{RMariaDB::MariaDB()}} and \code{\link[RSQLite:SQLite]{RSQLite::SQLite()}}}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}} e.g. host, port, dbname, user and password}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupDriver(
  drv = RSQLite::SQLite(),
  dbname = ":memory:"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-setupPostgreSQL"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-setupPostgreSQL}{}}}
\subsection{Method \code{setupPostgreSQL()}}{
Setup database driver and define connection parameters for PostgreSQL using \link[RPostgres:Postgres]{RPostgres} package.
Wrapper for setupDriver() function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupPostgreSQL(
  host = "127.0.0.1",
  port = "5432",
  dbname = "mydb",
  user = "postgres",
  password = "password",
  protect = c("password", "user"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Host name or IP number}

\item{\code{port}}{Port number}

\item{\code{dbname}}{Database name}

\item{\code{user}}{User name}

\item{\code{password}}{Password}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupPostgreSQL(
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-setupMariaDB"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-setupMariaDB}{}}}
\subsection{Method \code{setupMariaDB()}}{
Setup database driver and define connection parameters for MariaDB using \link[RMariaDB:RMariaDB-package]{RMariaDB} package.
Wrapper for setupDriver() function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupMariaDB(
  host = "127.0.0.1",
  port = "3306",
  dbname = "mydb",
  user = "root",
  password = "password",
  protect = c("password", "user"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Host name or IP number}

\item{\code{port}}{Port number}

\item{\code{dbname}}{Database name}

\item{\code{user}}{User name}

\item{\code{password}}{Password}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupMariaDB(
  host = "127.0.0.1", port = "3306", dbname = "mydb",
  user = "root", password = "password"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-setupSQLite"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-setupSQLite}{}}}
\subsection{Method \code{setupSQLite()}}{
Setup database driver and define connection parameters for SQLite using \link[RSQLite:SQLite]{RSQLite} package.
Wrapper for setupDriver() function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupSQLite(dbname = ":memory:", protect = c("password", "user"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dbname}}{Database name}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite(
  dbname = ":memory:"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-unloadDriver"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-unloadDriver}{}}}
\subsection{Method \code{unloadDriver()}}{
Reset database driver and connection parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$unloadDriver(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, suitable parameters passed to \code{\link[DBI:dbDriver]{DBI::dbUnloadDriver()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-canConnect"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-canConnect}{}}}
\subsection{Method \code{canConnect()}}{
Test connection parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$canConnect(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, suitable parameters passed to \code{\link[DBI:dbCanConnect]{DBI::dbCanConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$canConnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-connect"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-connect}{}}}
\subsection{Method \code{connect()}}{
Establish database connection using stored parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$connect(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-disconnect"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-disconnect}{}}}
\subsection{Method \code{disconnect()}}{
Disconnect database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$disconnect(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-sendQuery"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-sendQuery}{}}}
\subsection{Method \code{sendQuery()}}{
Send SQL query to database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$sendQuery(statement, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL query (\code{SELECT})}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-getQuery"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-getQuery}{}}}
\subsection{Method \code{getQuery()}}{
Retrieve SQL query from database.
Combination of functions sendQuery(), fetch() and clearResult().
If required, database is automatically connected and disconnected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getQuery(statement, n = -1, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL query (\code{SELECT})}

\item{\code{n}}{Number of record to be fetched at once. All records will be fetched.}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Records
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$getQuery("SELECT * FROM mtcars;")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-sendStatement"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-sendStatement}{}}}
\subsection{Method \code{sendStatement()}}{
Send SQL statement to database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$sendStatement(statement, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL statement (\code{UPDATE, DELETE, INSERT INTO, ...})}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-execute"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-execute}{}}}
\subsection{Method \code{execute()}}{
Execute SQL statement in database.
Combination of functions execute and clearResult.
If required, database is automatically connected and disconnected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$execute(statement, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL statement (\code{UPDATE, DELETE, INSERT INTO, ...})}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of affected rows
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$execute("DELETE FROM mtcars WHERE gear = 3;")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-fetch"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-fetch}{}}}
\subsection{Method \code{fetch()}}{
Fetch SQL query result from database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$fetch(n = -1, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of record to be fetched}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbFetch]{DBI::dbFetch()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Records
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-hasCompleted"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-hasCompleted}{}}}
\subsection{Method \code{hasCompleted()}}{
Information whether all records were retrieved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$hasCompleted(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbHasCompleted]{DBI::dbHasCompleted()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch(5)
db$hasCompleted()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-getRowsAffected"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-getRowsAffected}{}}}
\subsection{Method \code{getRowsAffected()}}{
Information on number of affected rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getRowsAffected(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetRowsAffected]{DBI::dbGetRowsAffected()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of affected rows
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$getRowsAffected()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-getRowCount"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-getRowCount}{}}}
\subsection{Method \code{getRowCount()}}{
Information on number of retrieved rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getRowCount(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetRowCount]{DBI::dbGetRowCount()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of retrieved rows
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$getRowCount()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-columnInfo"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-columnInfo}{}}}
\subsection{Method \code{columnInfo()}}{
Information on query result columns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$columnInfo(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbColumnInfo]{DBI::dbColumnInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information table
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$columnInfo()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-getStatement"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-getStatement}{}}}
\subsection{Method \code{getStatement()}}{
Information on sent statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getStatement(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetStatement]{DBI::dbGetStatement()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Statement text
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getStatement()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-clearResult"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-clearResult}{}}}
\subsection{Method \code{clearResult()}}{
Clear query or statement result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$clearResult(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-begin"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-begin}{}}}
\subsection{Method \code{begin()}}{
Begin transaction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$begin(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:transactions]{DBI::dbBegin()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-commit"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-commit}{}}}
\subsection{Method \code{commit()}}{
Commit transaction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$commit(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:transactions]{DBI::dbCommit()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-rollback"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-rollback}{}}}
\subsection{Method \code{rollback()}}{
Rollback transaction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$rollback(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:transactions]{DBI::dbRollback()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$rollback()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-getInfoDrv"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-getInfoDrv}{}}}
\subsection{Method \code{getInfoDrv()}}{
Information on driver object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getInfoDrv(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information list
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$getInfoDrv()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-getInfoCon"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-getInfoCon}{}}}
\subsection{Method \code{getInfoCon()}}{
Information on connection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getInfoCon(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information list
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$getInfoCon()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-getInfoRes"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-getInfoRes}{}}}
\subsection{Method \code{getInfoRes()}}{
Information on result object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getInfoRes(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information list
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getInfoRes()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-isValidDrv"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-isValidDrv}{}}}
\subsection{Method \code{isValidDrv()}}{
Check driver object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$isValidDrv(onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onLostNull}}{TRUE or FALSE. If driver lost, set .drv to NULL}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$isValidDrv()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-isValidCon"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-isValidCon}{}}}
\subsection{Method \code{isValidCon()}}{
Check connection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$isValidCon(onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onLostNull}}{TRUE or FALSE. If connection lost, set .con to NULL}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$isValidCon()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-isValidRes"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-isValidRes}{}}}
\subsection{Method \code{isValidRes()}}{
Check result object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$isValidRes(onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onLostNull}}{TRUE or FALSE. If result lost, set .res to NULL}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$isValidRes()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-validateCon"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-validateCon}{}}}
\subsection{Method \code{validateCon()}}{
Check if an earlier opened connection is still open.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$validateCon(statement = NULL, onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{Optional SQL statement. If not set default validateQuery will be used.}

\item{\code{onLostNull}}{TRUE or FALSE. If connection lost, set .con to NULL}

\item{\code{...}}{Not used yet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$validateCon()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-createTable"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-createTable}{}}}
\subsection{Method \code{createTable()}}{
Create empty formatted table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$createTable(name, fields, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{fields}}{Template data.frame}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbCreateTable]{DBI::dbCreateTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-appendTable"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-appendTable}{}}}
\subsection{Method \code{appendTable()}}{
Append data to table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$appendTable(name, value, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{value}}{Values data.frame}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbAppendTable]{DBI::dbAppendTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of appended rows invisibly
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$appendTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-writeTable"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-writeTable}{}}}
\subsection{Method \code{writeTable()}}{
Write data to table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$writeTable(name, value, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{value}}{Values data.frame}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-readTable"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-readTable}{}}}
\subsection{Method \code{readTable()}}{
Read table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$readTable(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbReadTable]{DBI::dbReadTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Table
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$readTable("mtcars")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-removeTable"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-removeTable}{}}}
\subsection{Method \code{removeTable()}}{
Remove table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$removeTable(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbRemoveTable]{DBI::dbRemoveTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$removeTable("mtcars")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-existsTable"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-existsTable}{}}}
\subsection{Method \code{existsTable()}}{
Check if table exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$existsTable(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbExistsTable]{DBI::dbExistsTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$existsTable("mtcars")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-listFields"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-listFields}{}}}
\subsection{Method \code{listFields()}}{
List table column names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$listFields(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbListFields]{DBI::dbListFields()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Column names
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listFields("mtcars")
db$disconnect()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-listObjects"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-listObjects}{}}}
\subsection{Method \code{listObjects()}}{
List database objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$listObjects(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbListObjects]{DBI::dbListObjects()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of objects
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listObjects()
db$disconnect()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rocker-listTables"></a>}}
\if{latex}{\out{\hypertarget{method-rocker-listTables}{}}}
\subsection{Method \code{listTables()}}{
List database tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$listTables(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbListTables]{DBI::dbListTables()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of objects
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listTables()
db$disconnect()
}
\if{html}{\out{</div>}}

}

}
}
