% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_graph_theme.R
\name{apply_graph_theme}
\alias{apply_graph_theme}
\title{Apply multiple DiagrammeR global graph attributes}
\usage{
apply_graph_theme(graph, ...)
}
\arguments{
\item{graph}{The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph to apply the attributes to.}

\item{...}{One or more character vectors of length three, where the first element is
the attribute, the second the value, and the third, the attribute type (\code{graph},
\code{node}, or \code{edge}).}
}
\value{
The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph.
}
\description{
Apply multiple DiagrammeR global graph attributes
}
\examples{
### Create an example source
exampleSource <- '
---
codes:
  -
    id: parentCode
    label: Parent code
    children:
      -
        id: childCode1
      -
        id: childCode2
  -
    id: childCode3
    label: Child Code
    parentId: parentCode
    children: [grandChild1, grandChild2]
---
';

### Parse it
parsedSource <-
  rock::parse_source(
    text = exampleSource
  );

### Extract the deductive code tree from
### the parsed source
deductiveCodeTree <-
  parsedSource$deductiveCodeTrees;

### Convert it to a DiagrammeR graph
miniGraph <-
  data.tree::ToDiagrammeRGraph(
    deductiveCodeTree
  );

### Show the graph
\donttest{DiagrammeR::render_graph(
  miniGraph
);}

### Apply a "theme" (three attributes)
miniGraph_themed <-
  rock::apply_graph_theme(
    miniGraph,
    c("rankdir", "TB", "graph"),
    c("shape", "square", "node"),
    c("style", "solid", "node"),
    c("fontname", "Arial", "node"),
    c("fontcolor", "#0000BB", "node"),
    c("color", "#BB0000", "node")
  );

### Show the updated graph
\donttest{DiagrammeR::render_graph(
  miniGraph_themed
);}
}
