% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pTab.R
\name{pTab}
\alias{pTab}
\title{Propability table}
\usage{
pTab(x, method = "dirichlet", alpha = 1/length(as.numeric(x)))
}
\arguments{
\item{x}{an object of class table}

\item{method}{default is \sQuote{dirichlet}. Other available methods: 
\sQuote{classical} that is function \code{prop.table()} from package base or method \dQuote{half} that add 1/2 to each cell
to avoid zero problems.}

\item{alpha}{constant used for method \sQuote{dirichlet}}
}
\value{
The probablity table
}
\description{
Calculates the propability table using different methods
}
\examples{
data(precipitation) 
pTab(precipitation)
pTab(precipitation, method = "dirichlet")
}
\references{
Egozcue, J.J., Pawlowsky-Glahn, V., Templ, M., Hron, K. (2015)
Independence in contingency tables using simplicial geometry. 
\emph{Communications in Statistics - Theory and Methods}, 44 (18), 3978--3996.
}
\author{
Matthias Templ
}
