% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskyr_sims.R
\name{write_popu}
\alias{write_popu}
\title{Write a population table (data) from a riskyr scenario (description).}
\format{
An object of class \code{data.frame}
with \code{\link{N}} rows and 3 columns
(e.g., \code{"X/truth/cd", "Y/test/dc", "SDT/cell/class"}).
}
\usage{
write_popu(x = NULL, ...)
}
\arguments{
\item{x}{A \code{\link{riskyr}} scenario (description).}

\item{...}{Additional parameters (text labels, passed to \code{\link{comp_popu}}).}
}
\value{
A data frame \code{popu}
containing \code{\link{N}} rows (individual cases)
and 3 columns (e.g., \code{"X/truth/cd", "Y/test/dc", "SDT/cell/class"}).
encoded as ordered factors (with 2, 2, and 4 levels, respectively).
}
\description{
\code{write_popu} computes (or expands) a table \code{\link{popu}}
(as an R data frame) from a \code{\link{riskyr}} scenario (description),
using its 4 essential frequencies.
}
\details{
\code{write_popu} expects a \code{\link{riskyr}} scenario as input
and passes its 4 essential frequencies (rounded to integers)
to \code{\link{comp_popu}}.

By default, \code{write_popu} uses the text settings
contained in \code{\link{txt}}, but labels can be changed
by passing arguments to \code{\link{comp_popu}} (via \code{...}).
}
\examples{
# Define scenarios (by description):
s1 <- riskyr(prev = .5, sens = .5, spec = .5, N = 10)  # s1: define by 3 prob & N
s2 <- riskyr(hi = 2, mi = 3, fa = 2, cr = 3)           # s2: same scenario by 4 freq

# Create data (from descriptions):
write_popu(s1)  # data from (prob) description
write_popu(s2,  # data from (freq) description & change labels:
           cond_lbl = "Disease (X)",
           cond_true_lbl = "sick", cond_false_lbl = "healthy",
           dec_lbl = "Test (Y)")

# Rounding:
s3 <- riskyr(prev = 1/3, sens = 2/3, spec = 6/7, N = 10, round = FALSE)  # s3: w/o rounding
write_popu(s3, cond_lbl = "X", dec_lbl = "Y", sdt_lbl = "class")  # rounded to nearest integers

# Sampling:
s4 <- riskyr(prev = 1/3, sens = 2/3, spec = 6/7, N = 10, sample = TRUE)  # s4: with sampling
write_popu(s4, cond_lbl = "X", dec_lbl = "Y", sdt_lbl = "class")  # data from sampling

}
\seealso{
\code{\link{comp_popu}} creates data (as df) from description (frequencies);
\code{\link{read_popu}} creates a scenario (description) from data (as df);
\code{\link{popu}} for data format;
\code{\link{txt}} for current text settings;
\code{\link{riskyr}} initializes a \code{riskyr} scenario.

Other functions converting data/descriptions: 
\code{\link{comp_popu}()},
\code{\link{read_popu}()}
}
\concept{functions converting data/descriptions}
