% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_use_and_trade.R
\name{rl_use_and_trade}
\alias{rl_use_and_trade}
\title{IUCN Red List use and trade categories}
\usage{
rl_use_and_trade(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character. One or more use/trade codes (e.g., "1", "5_2").
Use \code{\link[=rl_use_and_trade]{rl_use_and_trade()}} to list available categories.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available use and trade categories with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified use/trade category(ies), including
description, code, year, latest, and other relevant metatdata.
}
\description{
Retrieve species assessments based on use and trade categories.
If \code{code = NULL}, it returns a list of available use and trade categories.
If \code{code} is provided, it retrieves assessments for species affected by the specified use/trade category(ies).
}
\examples{
\dontrun{
# List all use and trade categories
rl_use_and_trade()

# Get species used for food - human (code 1)
rl_use_and_trade(code = "1")

# Get species hunted for Sport hunting/specimen collecting published in 2024
rl_use_and_trade(
  code = "15",
  year_published = 2024
)
}
}
