% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isZeroCodedCheckField.R
\name{isZeroCodedCheckField}
\alias{isZeroCodedCheckField}
\alias{warnOfZeroCodedCheckCasting}
\alias{warnZeroCodedFieldPresent}
\title{Identify Check Fields with a Zero Coded Option}
\usage{
isZeroCodedCheckField(field_name)

warnOfZeroCodedCheckCasting(field_name, x)

warnZeroCodedFieldPresent(field_names, warn_zero_coded)
}
\arguments{
\item{field_name}{\code{character(1)} The name of a field to be tested.}

\item{x}{\code{atomic} object.}

\item{field_names}{\code{character} vector of field names.}

\item{warn_zero_coded}{\code{logical(1)}. Turn on or off warnings about zero coded fields. Defaults to \code{TRUE}.}
}
\value{
\code{isZeroCodedCheckField} returns a \code{logical(1)}

\code{warnOfZeroCodedCheckCasting} has no return and issues a warning if the
field name appears to be zero-coded.

\code{warnZeroCodedFieldPresent} has no return and issues a warning if any
of the fields passed appear to be zero-coded.
}
\description{
Check fields that have \code{0} as a coding option can confuse
certain data processing steps because it can be difficult to
differentiate if a \code{0} value represents an unchecked or checked
option. Identifying these fields is important to handling them
correctly.
}
\section{Zero-Coded Check Fields}{

A zero-coded check field is a field of the REDCap type \code{checkbox} that has
a coding definition of \verb{0, [label]}. When exported, the field names for
these fields is \verb{[field_name]___0}. As in other checkbox fields, the
raw data output returns binary values where 0 represent an unchecked
box and 1 represents a checked box. For zero-coded checkboxes, then, a
value of 1 indicates that 0 was selected.

This coding rarely presents a problem when casting from raw values
(as is done in \code{exportRecordsTyped}). However, casting from coded or
labeled values can be problematic. In this case, it becomes
indeterminate from context if the intent of \code{0} is 'false' or the coded
value '0' ('true') ...

The situations in which casting may fail to produce the desired results are\tabular{lll}{
   Code \tab Label \tab Result \cr
   0 \tab anything other than "0" \tab Likely to fail when casting from coded values \cr
   0 \tab 0 \tab Likely to fail when casting from coded or labeled values \cr
}


Because of the potential for miscast data, casting functions will issue
a warning anytime a zero-coded check field is encountered. A separate
warning is issued when a field is cast from coded or labeled values.

When casting from coded or labeled values, it is strongly recommended that
the function \code{\link[=castCheckForImport]{castCheckForImport()}} be used. This function permits the
user to state explicitly which values should be recognized as checked,
avoiding the ambiguity resulting from the coding.
}

\examples{
\dontrun{
isZeroCodedCheckField("check_field___x")

isZeroCodedCheckField("check_field___0")


x <- factor(c(1, 0, 1, 0, 0),
            levels = 0:1)
warnOfZeroCodedCheckCasting(field_name = "check_field___0",
                            x = x)


warnZeroCodedFieldPresent(c("check_field___x", "check_field___0"), TRUE)
}
}
