% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlockREDCap.R
\name{connectAndCheck}
\alias{connectAndCheck}
\title{Connect to REDCap and verify connection}
\usage{
connectAndCheck(key, url, ...)
}
\arguments{
\item{key}{The API key used to connect.}

\item{url}{The url of the REDCap server.}

\item{...}{Additional arguments passed to redcapConnection}
}
\value{
redcapConnection established or NULL if key is invalid.
}
\description{
A function that given an API_KEY and a url will create a \code{redcapConnection}
object and verify that it is working with a version call.
If the API key is invalid it will return NULL.
If the URL is invalid or there are multiple redirects it will call \code{stop}.
}
\examples{
\dontrun{
connectAndCheck("<AN API KEY HERE>", "<REDCAP URL HERE>")
}
}
\seealso{
\code{\link[=redcapConnection]{redcapConnection()}}
}
