% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\docType{methods}
\name{changeVariables}
\alias{changeVariables}
\alias{changeVariables,ratioOfQsprays,list-method}
\title{Change of variables in a 'ratioOfQsprays' fraction of polynomials}
\usage{
\S4method{changeVariables}{ratioOfQsprays,list}(x, listOfQsprays)
}
\arguments{
\item{x}{a \code{ratioOfQsprays} fraction of polynomials}

\item{listOfQsprays}{a list containing at least \code{n} \code{qspray}
objects, or objects coercible to \code{qspray} objects, where
\code{n} is the number of variables of the \code{ratioOfQsprays} fraction
of polynomials given in the \code{x} argument; if this list is named,
then its names will be used in the show options of the result}
}
\value{
The \code{ratioOfQsprays} fraction of polynomials obtained by
  replacing the variables of the fraction of polynomials given in the
  \code{x} argument with the \code{qspray} polynomials given in the
  \code{listOfQsprays} argument.
}
\description{
Replaces the variables of a \code{ratioOfQsprays} fraction of
  polynomials with some \code{qspray} polynomials. E.g. you have a fraction
  of polynomials \eqn{R(x, y)} and you want the fraction of polynomials
  \eqn{R(x^2, x+y+1)}.
}
\examples{
library(ratioOfQsprays)
f <- function(x, y) {
  (x^2 + 5*y - 1) / (x + 1)
}
x <- qlone(1)
y <- qlone(2)
R <- f(x, y)
X <- x^2
Y <- x + y + 1
S <- changeVariables(R, list(X, Y))
S == f(X, Y) # should be TRUE
}
