% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_rast.R
\name{to_rast.sim_results}
\alias{to_rast.sim_results}
\title{Convert \code{sim_results} To SpatRaster}
\usage{
\method{to_rast}{sim_results}(obj, time_points = obj$simulated_time, template = NULL, ...)
}
\arguments{
\item{obj}{\code{sim_results} object created by \code{\link{sim}}}

\item{time_points}{numeric vector of length 1 or more; specifies points in
time from which \code{\link[terra:SpatRaster-class]{SpatRaster}} will be created - as
default the last year of simulation; if \code{length(time_points) > 0}
\code{\link[terra:SpatRaster-class]{SpatRaster}} will be returned with layers for
each element of \code{time_points}}

\item{template}{\code{\link[terra:SpatRaster-class]{SpatRaster}} object; can be used
as a template to create returned object}

\item{...}{Currently unused.}
}
\value{
\code{\link[terra:SpatRaster-class]{SpatRaster}} based on \code{sim_results} object
with layers corresponding to \code{time_points}.
}
\description{
Converts selected subset of abundance matrices from
\code{sim_results} into \code{\link[terra:SpatRaster-class]{SpatRaster}} object. Layers are
specified by \code{time_points}, which can be one or multiple points in time.
}
\examples{
\donttest{

# data preparation
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)

# simulation
sim_1 <- sim(obj = sim_data, time = 100)

# raster construction
my_rast <- to_rast(
  sim_1,
  time_points = c(1, 10, 20, 100),
  template = sim_data$K_map
)

# visualization
plot(my_rast, range = range(sim_1$N_map, na.rm = TRUE))

}

}
\references{
Hijmans R (2024). terra: Spatial Data Analysis. R package version
1.7-81, \url{https://rspatial.github.io/terra/}, \url{https://rspatial.org/}
}
