% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randolist.R
\name{randolist}
\alias{randolist}
\title{Generate randomisation lists}
\usage{
randolist(
  n,
  arms = LETTERS[1:2],
  strata = NA,
  blocksizes = 1:3,
  pascal = TRUE,
  ...
)
}
\arguments{
\item{n}{total number of randomizations (per stratum)}

\item{arms}{arms to randomise}

\item{strata}{named list of stratification variables (see examples)}

\item{blocksizes}{numbers of each arm to include in blocks (see details)}

\item{pascal}{logical, whether to use pascal's triangle to determine block sizes}

\item{...}{arguments passed on to other methods}
}
\value{
object of class \code{randolist} which is a dataframe with additional
attributes ratio (randomisation ratio, e.g. 1:1, 2:1), arms (arm labels),
stratified (logical whether the list is stratified), and stratavars (the
stratification variables)
}
\description{
Randomisation lists are central to randomised trials. This function allows
to generate randomisation lists simply, via (optionally) stratified block randomisation
}
\details{
\code{blocksizes} defines the number of allocations to each arm in a block.
For example, if there are two arms, and \code{blocksizes} = 1, each block will
contain 2 randomisations. If \code{blocksizes} = \code{1:2}, each block will
contain either one of each arm, or two of each arm. Total block sizes are
therefore  \code{blocksizes * length(arms)}.

By default, frequency of the different block sizes is determined using Pascal's
triangle.
This has the advantage that small and large block sizes are less common than
intermediate sized blocks, which helps with making it more difficult to guess
future allocations, and reduces the risk of finishing in the middle of a large
block.

Unbalanced randomization is possible by specifying the same arm label multiple times.

To disable block randomisation, set \code{blocksizes} to the same value as \code{n}.
}
\examples{
# example code
randolist(10)
# one stratifying variable
randolist(10, strata = list(sex = c("M", "F")))
# two stratifying variables
randolist(10, strata = list(sex = c("M", "F"),
                            age = c("child", "adult")))
# different arm labels
randolist(10, arms = c("arm 1", "arm 2"))

# unbalanced (2:1) randomization
randolist(10, arms = c("arm 1", "arm 1", "arm 2"))


}
