% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instruments.R
\docType{class}
\name{GridPricedInstrument-class}
\alias{GridPricedInstrument-class}
\alias{GridPricedInstrument}
\title{Representation of financial instrument amenable to grid pricing schemes}
\description{
Our basic instrument defines a tenor/maturity, a method
to provide values in case of default, and a method
to correct instrument prices in light of exercise
decisions.
}
\section{Fields}{

\describe{
\item{\code{maturity}}{The tenor, expiration date or terminal date by which the value of this security will be certain.}

\item{\code{last_computed_grid}}{The most recently computed set of values from a grid pricing scheme.  Used internally for pricing chains of derivatives.}

\item{\code{name}}{A mnemonic name for the instrument, not used by ragtop}
}}

\section{Methods}{

\describe{
\item{\code{optionality_fcn(v, ...)}}{Return a version of \code{v} at time \code{t} corrected for any optionality conditions.}

\item{\code{recovery_fcn(v, S, t, ...)}}{Return recovery value, given non-default values \code{v} at time \code{t}.  Subclasses may be more elaborate, this method simply returns 0.0.}

\item{\code{terminal_values(v, ...)}}{Return a terminal value. defaults to simply calling \code{optionality_fcn}.}
}}

