/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RFactor;
import org.rosuda.REngine.RList;

public class REXP {
    protected REXPList attr;
    public static int maxDebugItems = 32;

    public REXP() {
    }

    public REXP(REXPList rEXPList) {
        this.attr = rEXPList;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isFactor() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isPairList() {
        return false;
    }

    public boolean isLogical() {
        return false;
    }

    public boolean isEnvironment() {
        return false;
    }

    public boolean isLanguage() {
        return false;
    }

    public boolean isExpression() {
        return false;
    }

    public boolean isSymbol() {
        return false;
    }

    public boolean isVector() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isComplex() {
        return false;
    }

    public boolean isRecursive() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public String[] asStrings() throws REXPMismatchException {
        throw new REXPMismatchException(this, "String");
    }

    public int[] asIntegers() throws REXPMismatchException {
        throw new REXPMismatchException(this, "int");
    }

    public double[] asDoubles() throws REXPMismatchException {
        throw new REXPMismatchException(this, "double");
    }

    public byte[] asBytes() throws REXPMismatchException {
        throw new REXPMismatchException(this, "byte");
    }

    public RList asList() throws REXPMismatchException {
        throw new REXPMismatchException(this, "list");
    }

    public RFactor asFactor() throws REXPMismatchException {
        throw new REXPMismatchException(this, "factor");
    }

    public Object asNativeJavaObject() throws REXPMismatchException {
        throw new REXPMismatchException(this, "native Java Object");
    }

    public int length() throws REXPMismatchException {
        throw new REXPMismatchException(this, "vector");
    }

    public boolean[] isNA() throws REXPMismatchException {
        throw new REXPMismatchException(this, "vector");
    }

    public int asInteger() throws REXPMismatchException {
        int[] nArray = this.asIntegers();
        return nArray[0];
    }

    public double asDouble() throws REXPMismatchException {
        double[] dArray = this.asDoubles();
        return dArray[0];
    }

    public String asString() throws REXPMismatchException {
        String[] stringArray = this.asStrings();
        return stringArray[0];
    }

    public REXP getAttribute(String string) {
        REXPList rEXPList = this._attr();
        if (rEXPList == null || !rEXPList.isList()) {
            return null;
        }
        return rEXPList.asList().at(string);
    }

    public boolean hasAttribute(String string) {
        REXPList rEXPList = this._attr();
        return rEXPList != null && rEXPList.isList() && rEXPList.asList().at(string) != null;
    }

    public int[] dim() {
        try {
            return this.hasAttribute("dim") ? this._attr().asList().at("dim").asIntegers() : null;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return null;
        }
    }

    public boolean inherits(String string) {
        if (!this.hasAttribute("class")) {
            return false;
        }
        try {
            String[] stringArray = this.getAttribute("class").asStrings();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
                    return true;
                }
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return false;
    }

    public REXPList _attr() {
        return this.attr;
    }

    public String toString() {
        return super.toString() + (this.attr != null ? "+" : "");
    }

    public String toDebugString() {
        return this.attr != null ? "<" + this.attr.toDebugString() + ">" + super.toString() : super.toString();
    }

    public double[][] asDoubleMatrix() throws REXPMismatchException {
        double[] dArray = this.asDoubles();
        REXP rEXP = this.getAttribute("dim");
        if (rEXP == null) {
            throw new REXPMismatchException(this, "matrix (dim attribute missing)");
        }
        int[] nArray = rEXP.asIntegers();
        if (nArray.length != 2) {
            throw new REXPMismatchException(this, "matrix (wrong dimensionality)");
        }
        int n = nArray[0];
        int n2 = nArray[1];
        double[][] dArray2 = new double[n][n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[j][i] = dArray[n3++];
            }
        }
        return dArray2;
    }

    public static REXP createDoubleMatrix(double[][] dArray) {
        double[] dArray2;
        int n = 0;
        int n2 = 0;
        if (dArray != null && dArray.length != 0 && dArray[0].length != 0) {
            n = dArray.length;
            n2 = dArray[0].length;
            dArray2 = new double[n * n2];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray2[n3++] = dArray[j][i];
                }
            }
        } else {
            dArray2 = new double[]{};
        }
        return new REXPDouble(dArray2, new REXPList(new RList(new REXP[]{new REXPInteger(new int[]{n, n2})}, new String[]{"dim"})));
    }

    public static REXP createDataFrame(RList rList) throws REXPMismatchException {
        if (rList == null || rList.size() < 1) {
            throw new REXPMismatchException(new REXPList(rList), "data frame (must have dim>0)");
        }
        if (!(rList.at(0) instanceof REXPVector)) {
            throw new REXPMismatchException(new REXPList(rList), "data frame (contents must be vectors)");
        }
        REXPVector rEXPVector = (REXPVector)rList.at(0);
        return new REXPGenericVector(rList, new REXPList(new RList(new REXP[]{new REXPString("data.frame"), new REXPString(rList.keys()), new REXPInteger(new int[]{Integer.MIN_VALUE, -rEXPVector.length()})}, new String[]{"class", "names", "row.names"})));
    }

    public static REXP asCall(REXP rEXP, REXP[] rEXPArray) {
        RList rList = new RList();
        rList.add(rEXP);
        for (int i = 0; i < rEXPArray.length; ++i) {
            rList.add(rEXPArray[i]);
        }
        return new REXPLanguage(rList);
    }

    public static REXP asCall(String string, REXP[] rEXPArray) {
        return REXP.asCall((REXP)new REXPSymbol(string), rEXPArray);
    }

    public static REXP asCall(String string, REXP rEXP) {
        return new REXPLanguage(new RList(new REXP[]{new REXPSymbol(string), rEXP}));
    }

    public static REXP asCall(String string, REXP rEXP, REXP rEXP2) {
        return new REXPLanguage(new RList(new REXP[]{new REXPSymbol(string), rEXP, rEXP2}));
    }

    public static REXP asCall(String string, REXP rEXP, REXP rEXP2, REXP rEXP3) {
        return new REXPLanguage(new RList(new REXP[]{new REXPSymbol(string), rEXP, rEXP2, rEXP3}));
    }

    public static REXP asCall(REXP rEXP, REXP rEXP2) {
        return new REXPLanguage(new RList(new REXP[]{rEXP, rEXP2}));
    }

    public static REXP asCall(REXP rEXP, REXP rEXP2, REXP rEXP3) {
        return new REXPLanguage(new RList(new REXP[]{rEXP, rEXP2, rEXP3}));
    }

    public static REXP asCall(REXP rEXP, REXP rEXP2, REXP rEXP3, REXP rEXP4) {
        return new REXPLanguage(new RList(new REXP[]{rEXP, rEXP2, rEXP3, rEXP4}));
    }
}

