% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSI2.R
\name{DSI2}
\alias{DSI2}
\title{Calculate the Disease severity Index (DSI) (frequency of each class)}
\usage{
DSI2(class, freq, max)
}
\arguments{
\item{class}{A numeric vector representing the classes.}

\item{freq}{A numeric vector representing the frequency of each class.
Must be the same length as 'class'.}

\item{max}{A numeric value representing the maximum possible class value.}
}
\value{
Returns a single numeric value representing the DSI.
}
\description{
This function calculates the Disease Severity Index (DSI) given a vector of classes,
a vector of frequencies, and a maximum possible class value. The DSI is calculated
as a weighted sum of class values, where each class is multiplied by its corresponding
frequency, then divided by the product of the total frequency and maximum class value,
and finally multiplied by 100 to get a percentage.
}
\examples{
DSI2(c(0, 1, 2, 3, 4), c(2, 0, 5, 0, 5), 4)

}
\seealso{
Other Disease quantification: 
\code{\link{CompMuCens}()},
\code{\link{DSI}()}
}
\concept{Disease quantification}
