% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompMuCens.R
\name{CompMuCens}
\alias{CompMuCens}
\title{Survival analysis for quantitative ordinal scale data.}
\usage{
CompMuCens(dat, scale, grade = TRUE, ckData = FALSE)
}
\arguments{
\item{dat}{Data frame containing the data to be processed.}

\item{scale}{A numeric vector indicating the scale or order of classes.}

\item{grade}{Logical. If TRUE, uses the class value. If FALSE, uses the NPE (Non-Parametric Estimate).}

\item{ckData}{Logical. If TRUE, returns the input data along with the results.
If FALSE, returns only the results.}
}
\value{
Returns a list containing the score statistic, hypothesis tests, adjusted significance level,
and conclusion based on pairwise comparisons.
}
\description{
Survival analysis for quantitative ordinal scale data.
}
\details{
To assist plant pathologists in analyzing quantitative ordinal scale data
and encourage the uptake of the interval-censored analysis method,
Chiang and collaborators have developed this function and provided
comprehensive explanation of the program code used
to implement class ratings analyzed through this method in this repository:
https://github.com/StatisticalMethodsinPlantProtection/CompMuCens
According to results in the paper, the method can be
applied to reduce the risk of type II errors when considering quantitative ordinal
data, which are widely used in plant pathology and related disciplines.The
function starts by converting the data into a censored data format
and performs multiple pairwise comparisons to determine significance
using the score statistic method.
}
\examples{
# Entering your data as ordinal rating scores
trAs=c(5,4,2,5,5,4,4,2,5,2,2,3,4,3,2,2,6,2,2,4,2,4,2,4,5,3,4,2,2,3)
trBs=c(5,3,2,4,4,5,4,5,4,4,6,4,5,5,5,2,6,2,3,5,2,6,4,3,2,5,3,5,4,5)
trCs=c(2,3,1,4,1,1,4,1,1,3,2,1,4,1,1,2,5,2,1,3,1,4,2,2,2,4,2,3,2,2)
trDs=c(5,5,4,5,5,6,6,4,6,4,3,5,5,6,4,6,5,6,5,4,5,5,5,3,5,6,5,5,5,6)
# Data shaping into input format
inputData = data.frame(treatment=c(rep("A",30),rep("B",30),rep("C",30),
rep("D",30)), x=c(trAs, trBs, trCs, trDs))
# Perform analysis using CompMuCens() function
CompMuCens(dat=inputData, scale=c(0,3,6,12,25,50,75,88,94,97,100,100),ckData=TRUE)

}
\references{
Chiang, K.S., Chang, Y.M., Liu, H.I., Lee, J.Y., El Jarroudi, M. and Bock, C., 2023. Survival Analysis
as a Basis to Test Hypotheses When Using Quantitative Ordinal Scale Disease Severity Data. Phytopathology,
in press. Available at: https://apsjournals.apsnet.org/doi/abs/10.1094/PHYTO-02-23-0055-R
}
\seealso{
Other Disease quantification: 
\code{\link{DSI}()},
\code{\link{DSI2}()}
}
\concept{Disease quantification}
