% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BPL.R
\name{BPL}
\alias{BPL}
\title{Binary Power Law Analysis for Spatial Disease Patterns}
\usage{
BPL(data)
}
\arguments{
\item{data}{A data frame containing the following columns:
\itemize{
\item \code{field}: The field identifier.
\item \code{n}: The number of observations in each quadrat.
\item \code{i}: The incidence count in each quadrat.
}}
}
\value{
A list containing the following elements:
\itemize{
\item \code{summary}: A data frame summarizing the input data by field, including total observations (\code{n_total}),
mean incidence (\code{incidence_mean}), observed variance (\code{V}), and binomial variance (\code{Vbin}).
\item \code{model_summary}: A summary of the linear model fitted to the log-transformed variances.
\item \code{hypothesis_test}: The result of the hypothesis test for the slope being equal to 1.
\item \code{ln_Ap}: The intercept of the linear model, representing the natural logarithm of the parameter \( A_p \).
\item \code{slope}: The slope of the linear model.
}
}
\description{
This function calculates the Binary Power Law (BPL) parameters for spatial disease patterns,
fits a linear model, and performs a hypothesis test for the slope.
}
\details{
The function performs the following steps:
\enumerate{
\item Summarizes the data by field to calculate the total number of observations (\code{n_total}),
mean incidence (\code{incidence_mean}), observed variance (\code{V}), and binomial variance (\code{Vbin}).
\item Log-transforms the variances.
\item Fits a linear model to the log-transformed variances.
\item Tests the hypothesis that the slope of the linear model is equal to 1.
}
}
\examples{
\donttest{
# Example usage with a sample data frame
result <- BPL(FHBWheat)
print(result$summary)
print(result$model_summary)
print(result$hypothesis_test)
print(paste("ln(Ap):", result$ln_Ap))
print(paste("Slope (b):", result$slope))
}
}
\seealso{
Other Spatial analysis: 
\code{\link{AFSD}()},
\code{\link{count_subareas}()},
\code{\link{count_subareas_random}()},
\code{\link{fit_gradients}()},
\code{\link{join_count}()},
\code{\link{oruns_test}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()},
\code{\link{plot_AFSD}()}
}
\concept{Spatial analysis}
