% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_sda.R
\name{target_sda}
\alias{target_sda}
\title{Add targets for \ifelse{html}{\out{CO<sub>2</sub>}}{\eqn{CO_2}{CO~2~}}
emissions per unit production at the portfolio level, using the SDA approach}
\usage{
target_sda(
  data,
  abcd,
  co2_intensity_scenario,
  use_credit_limit = FALSE,
  by_company = FALSE,
  region_isos = r2dii.data::region_isos
)
}
\arguments{
\item{data}{A dataframe like the output of
\code{r2dii.match::prioritize()}.}

\item{abcd}{An asset-level data frame like \link[r2dii.data:abcd_demo]{r2dii.data::abcd_demo}.}

\item{co2_intensity_scenario}{A scenario data frame like
\link[r2dii.data:co2_intensity_scenario_demo]{r2dii.data::co2_intensity_scenario_demo}.}

\item{use_credit_limit}{Logical vector of length 1. \code{FALSE} defaults to using
the column \code{loan_size_outstanding}. Set to \code{TRUE} to instead use the column
\code{loan_size_credit_limit}.}

\item{by_company}{Logical vector of length 1. \code{FALSE} defaults to outputting
\code{weighted_production_value} at the portfolio-level. Set to \code{TRUE} to output
\code{weighted_production_value} at the company-level.}

\item{region_isos}{A data frame like \link[r2dii.data:region_isos]{r2dii.data::region_isos} (default).}
}
\value{
A tibble including the summarized columns \code{emission_factor_metric} and
\code{emission_factor_value}. If \code{by_company = TRUE}, the output will also have
the column \code{name_abcd}.
}
\description{
This function calculates targets of
\ifelse{html}{\out{CO<sub>2</sub>}}{\eqn{CO_2}{CO~2~}} emissions per unit
production at the portfolio-level, otherwise referred to as "emissions
factors". It uses the \href{https://rmi-pacta.github.io/r2dii.analysis/articles/sda-target.html}{sectoral-decarbonization approach (SDA)}
to calculate these targets.
}
\section{Handling grouped data}{

This function ignores existing groups and outputs ungrouped data.
}

\examples{
\dontshow{if (rlang::is_installed("r2dii.data") && rlang::is_installed("r2dii.match", version = "0.1.0")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(r2dii.match)
library(r2dii.data)

loanbook <- head(loanbook_demo, 150)
abcd <- head(abcd_demo, 100)

matched <- loanbook \%>\%
  match_name(abcd) \%>\%
  prioritize()

# Calculate targets at portfolio level
matched \%>\%
  target_sda(
   abcd = abcd,
   co2_intensity_scenario = co2_intensity_scenario_demo,
   region_isos = region_isos_demo
   )

# Calculate targets at company level
matched \%>\%
  target_sda(
   abcd = abcd,
   co2_intensity_scenario = co2_intensity_scenario_demo,
   region_isos = region_isos_demo,
   by_company = TRUE
   )
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions to calculate scenario targets: 
\code{\link{target_market_share}()}
}
\concept{functions to calculate scenario targets}
