% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_data.R
\name{scan_data}
\alias{scan_data}
\title{Scan Entire Dataset for Outliers}
\usage{
scan_data(data, method = "iqr")
}
\arguments{
\item{data}{A data frame.}

\item{method}{"iqr" or "zscore". Defaults to "iqr".}
}
\value{
A summary data frame with columns: Column, Outlier_Count, and Percentage.
}
\description{
Iterates through all numeric columns in the dataset and provides a summary table of outliers found.
}
\examples{
df <- data.frame(
  a = c(1:10, 100),
  b = c(1:10, 1)
)
scan_data(df, method = "iqr")
}
