% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwrttest.r
\name{pwrttest}
\alias{pwrttest}
\title{Power Analysis for One-/Two-Sample and Paired t Tests}
\usage{
pwrttest(
  paired = FALSE,
  onesample = FALSE,
  n_total = NULL,
  alpha = NULL,
  power = NULL,
  delta = NULL,
  cohensf = NULL,
  peta2 = NULL,
  alternative = c("two.sided", "one.sided"),
  nlim = c(2, 10000)
)
}
\arguments{
\item{paired}{Logical. \code{FALSE} for two-sample (independent; default),
\code{TRUE} for paired/repeated-measures. Ignored when \code{onesample = TRUE}.}

\item{onesample}{Logical. \code{TRUE} for the one-sample \emph{t}-test; if \code{TRUE},
\code{paired} is ignored.}

\item{n_total}{Integer scalar. Total sample size.
If \code{NULL}, the function solves for \code{n_total}.}

\item{alpha}{Numeric in \eqn{(0,1)}. If \code{NULL}, it is solved for given the other inputs.}

\item{power}{Numeric in \eqn{(0,1)}. If \code{NULL}, it is computed; if \code{n_total} is \code{NULL},
\code{n_total} is solved to attain this power.}

\item{delta}{Numeric (non-negative). Cohen's \eqn{d}-type effect size.
If \code{NULL}, it is derived from \code{cohensf} or \code{peta2} when available.
If all three effect-size arguments (\code{delta}, \code{cohensf}, \code{peta2})
are \code{NULL}, then the effect size is treated as the unknown quantity and is
solved for given \code{n_total}, \code{alpha}, and \code{power}.
The exact definition depends on the design:
\itemize{
\item \emph{One-sample}: Cohen's \eqn{d = (\mu - \mu_0)/\sigma}.
\item \emph{Paired}: Cohen's \eqn{d_z = \bar{d}/s_d}, i.e., the mean of the difference scores
divided by their standard deviation.
\item \emph{Two-sample (equal allocation)}: Cohen's \eqn{d} is defined as the mean difference
divided by the pooled standard deviation; internally related to \eqn{f} via \eqn{d = 2f}.
}
If \code{NULL}, \code{delta} is derived from \code{cohensf} or \code{peta2} when available.}

\item{cohensf}{Numeric (non-negative). Cohen's \eqn{f}.
If \code{NULL}, it can be derived from \code{delta};
if \code{delta} is supplied, \code{cohensf} is ignored.
Effect-size relations by design:
\itemize{
\item Two-sample (equal allocation): \eqn{d = 2f}
\item Paired: \eqn{d_z = f}
\item One-sample: \eqn{f} and \eqn{\eta_p^2} are not supported
}}

\item{peta2}{Numeric in \eqn{(0,1)}. Partial eta squared.
If \code{NULL}, it can be derived from \code{cohensf};
if \code{delta} is supplied, \code{peta2} is ignored.
Not defined for one-sample designs.}

\item{alternative}{Character. Either \code{"two.sided"} or \code{"one.sided"}.}

\item{nlim}{Integer vector of length 2. Search range of total \code{n} when solving sample size.}
}
\value{
A one-row \code{data.frame} with class
\code{"cal_power"}, \code{"cal_n"}, \code{"cal_alpha"}, or \code{"cal_es"},
depending on the solved quantity. Columns:
\code{df}, \code{n_total}, \code{alpha}, \code{power},
\code{delta}, \code{cohensf}, \code{peta2},
\code{t_critical}, \code{ncp}.
}
\description{
Computes statistical power, required total sample size, \eqn{\alpha},
or the minimal detectable effect size for a \emph{t}-test in one of three designs:
one-sample, two-sample (independent), or paired/repeated measures.
}
\details{
\itemize{
\item If multiple effect-size arguments are supplied (\code{delta}, \code{cohensf}, \code{peta2}),
precedence is \code{delta} \eqn{>} \code{cohensf} \eqn{>} \code{peta2}; the rest are ignored with a warning.
\item For the two-sample design, equal allocation is assumed; \code{n_total} must be even when provided,
and the solved \code{n_total} will be an even number.
\item For the paired design, the effect size is interpreted as \eqn{d_z}.
\item Computations use the central and noncentral \emph{t}-distributions (\code{stats::qt}, \code{stats::pt});
root finding uses \code{stats::uniroot()} where needed.
\item Results have been validated to match those produced by G*Power
for equivalent one-sample, paired, and two-sample \emph{t} tests.
}
}
\examples{
# (1) Two-sample (independent), compute power given N and d
pwrttest(paired = FALSE, onesample = FALSE, alternative = "two.sided",
         n_total = 128, delta = 0.50, alpha = 0.05)

# (2) Paired t-test, solve required N for target power
pwrttest(paired = TRUE, onesample = FALSE, alternative = "one.sided",
         n_total = NULL, delta = 0.40, alpha = 0.05, power = 0.90)

# (3) One-sample t-test, solve alpha given N and power
pwrttest(onesample = TRUE, alternative = "two.sided",
         n_total = 40, delta = 0.40, alpha = NULL, power = 0.80)

# (4) Two-sample, specify effect via f or partial eta^2 (converted internally)
pwrttest(paired = FALSE, cohensf = 0.25, n_total = NULL, alpha = 0.05, power = 0.80)

}
