% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cuts_portfolio.R
\name{add_cuts_portfolio}
\alias{add_cuts_portfolio}
\title{Add Bender's cuts portfolio}
\usage{
add_cuts_portfolio(x, number_solutions = 10)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{number_solutions}{\code{integer} number of attempts to generate
different solutions. Defaults to 10.}
}
\value{
An updated \code{\link[=problem]{problem()}} object with the portfolio added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
problem using Bender's cuts (discussed in Rodrigues
\emph{et al.} 2000). This is recommended as a replacement for
\code{\link[=add_gap_portfolio]{add_gap_portfolio()}} when the \emph{Gurobi} software is not
available.
}
\details{
This strategy for generating a portfolio of solutions involves
solving the problem multiple times and adding additional constraints
to forbid previously obtained solutions. In general, this strategy is most
useful when problems take a long time to solve and benefit from
having multiple threads allocated for solving an individual problem.
}
\section{Notes}{

In early versions (< 4.0.1), this function was only compatible with
\emph{Gurobi} (i.e., \code{\link[=add_gurobi_solver]{add_gurobi_solver()}}). To provide functionality with
exact algorithm solvers, this function now adds constraints to the
problem formulation to generate multiple solutions.
}

\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()
sim_zones_pu_raster <- get_sim_zones_pu_raster()
sim_zones_features <- get_sim_zones_features()

# create minimal problem with cuts portfolio
p1 <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.2) \%>\%
  add_cuts_portfolio(10) \%>\%
  add_default_solver(gap = 0.2, verbose = FALSE)

# solve problem and generate 10 solutions within 20\% of optimality
s1 <- solve(p1)

# convert portfolio into a multi-layer raster object
s1 <- terra::rast(s1)

# plot solutions in portfolio
plot(s1, axes = FALSE)

# build multi-zone conservation problem with cuts portfolio
p2 <-
 problem(sim_zones_pu_raster, sim_zones_features) \%>\%
 add_min_set_objective() \%>\%
 add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5, ncol = 3)) \%>\%
 add_binary_decisions() \%>\%
 add_cuts_portfolio(10) \%>\%
 add_default_solver(gap = 0.2, verbose = FALSE)

# solve the problem
s2 <- solve(p2)

# print solution
str(s2, max.level = 1)

# convert each solution in the portfolio into a single category layer
s2 <- terra::rast(lapply(s2, category_layer))

# plot solutions in portfolio
plot(s2, main = "solution", axes = FALSE)
}
}
\references{
Rodrigues AS, Cerdeira OJ, and Gaston KJ (2000) Flexibility,
efficiency, and accountability: adapting reserve selection algorithms to
more complex conservation problems. \emph{Ecography}, 23: 565--574.
}
\seealso{
See \link{portfolios} for an overview of all functions for adding a portfolio.

Other functions for adding portfolios:
\code{\link{add_default_portfolio}()},
\code{\link{add_extra_portfolio}()},
\code{\link{add_gap_portfolio}()},
\code{\link{add_shuffle_portfolio}()},
\code{\link{add_top_portfolio}()}
}
\concept{portfolios}
