% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_mean.R
\name{norm_mean}
\alias{norm_mean}
\title{Mean Normalization}
\usage{
norm_mean(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Logical. Should NA values be removed during calculation?
Default is \code{TRUE}.}
}
\value{
A numeric vector.
  If the range is 0 (all values are identical), returns a centered vector (zeros).
}
\description{
Scales a numeric vector by centering it around its mean and scaling it by its range.
The resulting vector has a mean of 0 and values typically within [-1, 1].
}
\details{
Formula: \eqn{x' = \frac{x - \text{mean}(x)}{\max(x) - \min(x)}}
}
\examples{
# Result ranges from approx -0.5 to 0.5, mean is 0
norm_mean(c(1, 2, 3, 4, 5))

# Handles negative values
norm_mean(c(-10, 0, 10))
}
\references{
Han, J., Kamber, M., & Pei, J. (2011). \emph{Data mining: concepts and techniques} (3rd ed.). Morgan Kaufmann.
}
