% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{alignStrings}
\alias{alignStrings}
\title{Align printed output to the longest argument}
\usage{
alignStrings(x, names = NULL, pad = c("l", "c", "r"))
}
\arguments{
\item{x}{A numeric vector or matrix to be aligned with a vector of column names.}

\item{names}{Optional: if x does not have (column) names, a character vector of element
or column names to be output first. Ignored if \code{x} is named.
Numeric inputs are converted to character automatically.}

\item{pad}{A single character: \code{"l"} for left padding (flush-right justification),
\code{"c"} for centre, and \code{"r"} for right padding (flush-left justification).}
}
\value{
A character matrix with the first row of names and the rest aligned content
}
\description{
Align printed output to the longest argument
}
\examples{
x <- structure(1:4, names = month.name[1:4])
print(alignStrings(x, names(x)), quote = FALSE)
print(alignStrings(x, names(x), pad = "c"), quote = FALSE)  # Centring
print(alignStrings(x, names(x), pad = "r"), quote = FALSE)  # Left alignment

x <- matrix(c(1, 2.3, 4.567, 8, 9, 0), nrow = 2, byrow = TRUE)
colnames(x) <- c("Andy", "Bradley", "Ci")
alignStrings(x, pad = "c")
}
