% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_storage.R
\name{api_session_cookie}
\alias{api_session_cookie}
\title{Turn on session cookie data storage for your API}
\usage{
api_session_cookie(
  api,
  key,
  name = "reqres",
  expires = NULL,
  max_age = NULL,
  path = NULL,
  secure = NULL,
  same_site = NULL
)
}
\arguments{
\item{api}{A plumber2 api object to add the session cookie setup to}

\item{key}{A 32-bit secret key as a hex encoded string or a raw vector to
use for encrypting the session cookie. A valid key can be generated using
\code{\link[reqres:random_key]{reqres::random_key()}}. NEVER STORE THE KEY IN PLAIN TEXT. Optimally use the
keyring package to store it}

\item{name}{The name of the cookie}

\item{expires}{A POSIXct object given the expiration time of the cookie}

\item{max_age}{The number of seconds to elapse before the cookie expires}

\item{path}{The URL path this cookie is related to}

\item{secure}{Should the cookie only be send over https}

\item{same_site}{Either \code{"Lax"}, \code{"Strict"}, or \code{"None"} indicating
how the cookie can be send during cross-site requests. If this is set to
\code{"None"} then \code{secure} \emph{must} also be set to \code{TRUE}}
}
\value{
These functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
If you need to keep data between requests, but don't want to store it
server-side (see \code{\link[=api_datastore]{api_datastore()}}) you can instead pass it back and forth as
an encrypted session cookie. This function sets it up on your api and after
it's use you can now access and set session data in the request and response
\verb{$session} field. Be aware that session data is send back and forth with all
requests and should thus be kept minimal to avoid congestion on your server.
}
\section{Using annotation}{
Session cookie setup doesn't have a dedicated annotation tag, but you can set
it up in a \verb{@plumber} block

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* @plumber
function(api) \{
  api |>
    api_session_cookie(keyring::key_get("my_secret_plumber_key"))
\}
}\if{html}{\out{</div>}}
}

\examples{
key <- reqres::random_key()

api() |>
  api_session_cookie(key, secure = TRUE) |>
  api_get("/", function(request) {
    if (isTRUE(request$session$foo)) {
      msg <- "You've been here before"
    } else {
      msg <- "You must be new here"
      request$session$foo <- TRUE
    }
    list(
      msg = msg
    )
  })

}
