% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_handlers.R
\name{api_forward}
\alias{api_forward}
\title{Set up a plumber2 api to act as a reverse proxy}
\usage{
api_forward(api, path, url, except = NULL)
}
\arguments{
\item{api}{A plumber2 api to add the shiny app to}

\item{path}{The path to serve the shiny app from}

\item{url}{The url to forward to}

\item{except}{Subpaths to \code{path} that should be exempt from forwarding}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
You can set up your plumber2 api to act as reverse proxy and forward all
requests to a specific path (and it's subpaths) to a different URL. In
contrast to \code{\link[=api_shiny]{api_shiny()}}, \code{api_forward()} is not responsible for launching
whatever service is being proxied so this should be handled elsewhere. The
\code{path} will be stripped from the request before being forwarded to the url,
meaning that if you set up a proxy on \verb{my/proxy/} to \verb{http://example.com},
then a request for \code{my/proxy/user/thomas} will end at
\verb{http://example.com/user/thomas}. Proxying is most useful when forwarding to
internal servers though you are free to forward to public URLs as well.
However, for the later you'd usually use a redirect instead (via
\code{\link[=api_redirect]{api_redirect()}})
}
\section{Using annotation}{
You can set up a reverse proxy in your annotated route file using the
\verb{@forward} tag

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* @forward /proxy http://127.0.0.1:56789
NULL
}\if{html}{\out{</div>}}
}

\examples{
# Serve wikipedia directly from your app
api() |>
  api_forward("my_wiki/", "https://www.wikipedia.org")

}
