% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.plsRglmmodel.R
\name{print.plsRglmmodel}
\alias{print.plsRglmmodel}
\title{Print method for plsRglm models}
\usage{
\method{print}{plsRglmmodel}(x, ...)
}
\arguments{
\item{x}{an object of the class \code{"plsRglmmodel"}}

\item{\dots}{not used}
}
\value{
\code{NULL}
}
\description{
This function provides a print method for the class \code{"plsRglmmodel"}
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
modplsglm <- plsRglm(yCornell,XCornell,3,modele="pls-glm-gaussian")
class(modplsglm)
print(modplsglm)
rm(list=c("XCornell","yCornell","modplsglm"))

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparaison de la
régression PLS et de la régression
logistique PLS : application aux données
d'allélotypage. \emph{Journal de la Société Française
de Statistique}, 151(2), pages 1-18.
\url{https://www.numdam.org/item/JSFS_2010__151_2_1_0/}
}
\seealso{
\code{\link{print}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{methods}
\keyword{print}
