% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{sortGroups}
\alias{sortGroups}
\title{Sort groups based on a function such as mean value or deviation.}
\usage{
sortGroups(formula, FUN = "mean", decreasing = FALSE, ...)
}
\arguments{
\item{formula}{Formula for splitting the data}

\item{FUN}{Function to apply to each group}

\item{decreasing}{Logical: sort groups on decreasing values or not 
(default is FALSE, sorting on increasing values).}

\item{...}{Additional arguments for the function 
\code{\link[stats]{aggregate}}.}
}
\value{
The order of levels.
}
\description{
Sort groups based on a function such as mean value or deviation.
}
\examples{
head(ToothGrowth)
# sort on basis of mean length:
sortGroups(len ~ dose:supp, data = ToothGrowth)
labels = levels(interaction(ToothGrowth$dose, ToothGrowth$supp))
labels[sortGroups(len ~ dose:supp, data = ToothGrowth)]
}
\seealso{
Other Utility functions: 
\code{\link{findAbsMin}()},
\code{\link{find_n_neighbors}()},
\code{\link{firstLetterCap}()},
\code{\link{getArrowPos}()},
\code{\link{getDec}()},
\code{\link{getRange}()},
\code{\link{getRatioCoords}()},
\code{\link{get_palette}()},
\code{\link{group_sort}()},
\code{\link{inch2coords}()},
\code{\link{isColor}()},
\code{\link{keepFigRatio}()},
\code{\link{list2str}()},
\code{\link{move_n_point}()},
\code{\link{orderBoxplot}()},
\code{\link{se}()}
}
\author{
Jacolien van Rij
}
\concept{Utility functions}
