% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgInfo.R
\name{pkg_info}
\alias{pkg_info}
\title{Get Information for a Package}
\usage{
pkg_info(pkg, ver = "current", cache = TRUE)
}
\arguments{
\item{pkg}{The package name as a quoted string. This parameter is
required.}

\item{ver}{The version of the package to retrieve information for.
Pass the version as a quoted string.
Special values are "current" and
"latest".  The value "current" is the current version of the package
running on the machine.  The value "latest" is the latest version
of the package from CRAN.}

\item{cache}{Whether to retrieve the info from the Github cache, or
from CRAN.  If TRUE, the function will first search the cache, and
return the info if available.  If the info is not available in the
Github cache, or the cache parameter is set to FALSE, the info will be
retrieved from CRAN.}
}
\value{
A package information object of class "pinfo".  This object contains
a set of general information about the package, such as the version,
release date, maintainer, title, etc.  Most of this information comes
from the package description file.  In addition, the info object also
contains a list of functions in the package and their parameters.

If the package has been archived on CRAN, info will be returned,
but the "Archived" flag will be set to TRUE. If the
package is not found on CRAN, the function will emit a message and return
NULL.

If the package is a Base R package, a reduced number of fields will be returned,
and the package will be marked with \code{Base Package: TRUE}.  Function
lists are not available for Base packages.
}
\description{
Combines information related to a package. Objects of this class are
used by several other functions in the \strong{pkgdiff} system.  This
class also makes a compact storage format for pre-processed package
information.
}
\details{
Package information is unique for each version of a package.  Since
a package can have multiple versions, you must select which version
you wish to return information for.  By default, the version
returned is the current version of the package on the current machine.
You may also specify a previous version number from the CRAN archive.
Another option is to specify the latest version on CRAN.  See the
"ver" parameter for additional details on how to select these
different package versions.

The package info object contains a list of functions and function
parameters associated with the specified version of the package.
You may access this list using the \code{$Functions} item name.

Most other information contained in the info object is retrieved
from the package description file. One exception is the downloads
per month.  This information is retrieved from CRAN logs.

In addition, the package cache status is appended to the info object.
The package cache status indicates whether the package info
has been stored in the \strong{pkgdiff} Github cache.  Packages that
have been stored in the cache enjoy faster results from
\strong{pkgdiff} functions.

Note that \code{pkg_info} and other \strong{pkgdiff} functions
only work with contributed CRAN packages.  They do not
work with Base R packages.
}
\examples{
# View package info
pkg_info("glue")
# A package info object: glue package
# - Version: v1.7.0
# - Release Date: 2024-01-09
# - Title: Interpreted String Literals
# - Maintainer: Jennifer Bryan <jenny@posit.co>
# - License: MIT + file LICENSE
# - Description: An implementation of interpreted string literals, inspired by
# Python's Literal String Interpolation
# <https://www.python.org/dev/peps/pep-0498/> and Docstrings
# <https://www.python.org/dev/peps/pep-0257/> and Julia's Triple-Quoted
# String Literals
# <https://docs.julialang.org/en/v1.3/manual/strings/#Triple-Quoted-String-Literals-1>.
#   - Depends: R (>= 3.6)
# - Imports: methods
# - Suggests: crayon, DBI (>= 1.2.0), dplyr, knitr, magrittr, rlang,
# rmarkdown, RSQLite, testthat (>= 3.2.0), vctrs (>= 0.3.0),
# waldo (>= 0.3.0), withr
# - Downloads/Month: 1463244
# - Repository: CRAN
# - Cached: TRUE
# - Functions: 24

# Get info object
res <- pkg_info("glue")

# Extract package version
res$Version
# [1] "1.7.0"

# Extract maintainer
res$Maintainer
# [1] "Jennifer Bryan <jenny@posit.co>"

# Extract function list
res$Functions
# $`[.glue`
# [1] "x"   "i"   "..."
#
# $`[[.glue`
# [1] "x"   "i"   "..."
#
# $`+.glue`
# [1] "e1" "e2"
#
# $as.character.glue
# [1] "x"   "..."
#
# $as_glue
# [1] "x"   "..."
#
# $as_glue.character
# [1] "x"   "..."
#
# $as_glue.default
# [1] "x"   "..."
#
# $as_glue.glue
# [1] "x"   "..."
#
# $backtick
# [1] "x"
#
# $double_quote
# [1] "x"
#
# $glue
# [1] "..."          ".sep"         ".envir"
# [4] ".open"        ".close"       ".na"
# [7] ".null"        ".comment"     ".literal"
# [10] ".transformer" ".trim"
# ...
}
\seealso{
Other pdiff: 
\code{\link{pkg_cache}()},
\code{\link{pkg_diff}()},
\code{\link{pkg_stability}()},
\code{\link{pkg_versions}()},
\code{\link{print.pcache}()},
\code{\link{print.pdiff}()},
\code{\link{print.pdiff_score}()},
\code{\link{print.pinfo}()}
}
\concept{pdiff}
