% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{n_spans}
\alias{n_spans}
\alias{n_spans.default}
\alias{n_spans.Interval}
\alias{n_spans.phinterval}
\title{Count the number of spans in a phinterval}
\usage{
n_spans(phint)

\method{n_spans}{default}(phint)

\method{n_spans}{Interval}(phint)

\method{n_spans}{phinterval}(phint)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}
}
\value{
An integer vector the same length as \code{phint}.
}
\description{
\code{n_spans()} counts the number of disjoint time spans in each element of
\code{phint}.
}
\examples{
# Count spans
y2000 <- interval(as.Date("2000-01-01"), as.Date("2001-01-01"))
y2025 <- interval(as.Date("2025-01-01"), as.Date("2025-01-01"))

n_spans(c(
 phint_union(y2000, y2025),
 phint_intersect(y2000, y2025),
 y2000, y2025
))

}
