% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.null.R
\name{generic.metrics}
\alias{generic.metrics}
\alias{generic.null}
\alias{.ses}
\alias{.metric.null}
\title{Calculate any metric(s) (and compare with null distributions)}
\usage{
generic.null(
  data,
  metrics,
  null.model = c("taxa.labels", "richness", "frequency", "sample.pool", "phylogeny.pool",
    "independentswap", "trialswap", "trait.asm"),
  permute = 1000,
  comp.fun = .ses,
  ...
)

.ses(observed, null)

.metric.null(
  data,
  metrics,
  null.model = c("taxa.labels", "richness", "frequency", "sample.pool", "phylogeny.pool",
    "independentswap", "trialswap", "trait.asm"),
  permute = 1000,
  trait = -1,
  ...
)

generic.metrics(data, metrics, ...)
}
\arguments{
\item{data}{data \code{\link{comparative.comm}} object}

\item{metrics}{vector of functions to be calculated on \code{data};
see \link{pez.metrics} for a list of them.}

\item{null.model}{one of "taxa.labels", "richness", "frequency",
"sample.pool", "phylogeny.pool", "independentswap", or
"independentswap". These correspond to the null models available in
\CRANpkg{picante}}

\item{permute}{number of null permutations to perform (default
1000)}

\item{comp.fun}{comparison function to compare observed values with
null values. Default is \code{\link{.ses}}; this is a Standard
Effect Size (obs - mean)/SEmean. You may supply your own function;
it should take the observed site-metric matrix as its first
argument, and a site-metric-permutation array as its second. See
the internals of \code{\link{generic.null}} for an example of its
use.}

\item{...}{additional arguments (e.g, \code{dist},
\code{abundance.weighted}) to be passed to any metric functions
(see \code{\link{generic.metrics}} for possible arguments)}

\item{observed}{observed metric values in site-metric matrix
(\emph{e.g.}, from \code{\link{generic.metrics}})}

\item{null}{null distributions (\emph{e.g.}, from
\code{\link{.metric.null}}) in a site-metric-permutation array}

\item{trait}{if using \code{trait.asm} \code{null.model}, which
trait to use (as in \code{\link{trait.asm}})}
}
\value{
\code{generic.null} Output from \code{comp.fun}, by default
an array (site-metric-type), where type is the observed value, the
mean of the null permutations, the Standard Error of that mean, the
Standard Effect Size of the metric (obs-null.mean)/SE, and then the
rank of the observed value in the permutations. The rank can be
considered a bootstrapped p-value of significance, but remember
that this is a rank: at the 95% (two-tailed) level, a value of 0.99
would be significant.

\code{.ses} Vector of standard effect sizes

\code{.metric.null} site-metric-permutation array

\code{generic.metrics} site-metric matrix
}
\description{
Allow the calculation of any metric within \code{pez}.
}
\details{
\code{generic.null} Calculate metrics and compare with null
distributions. Very light wrapper around the utility functions
\code{\link{generic.null}} and \code{\link{generic.metrics}} (which
is, itself, a very simple function!).
}
\note{
\code{comp.fun} can be \emph{anything}; much ink has been
written about the use of standard effect sizes in eco-phylogenetic
analyses (\emph{e.g.}, Kembel 2009). That this function makes it
easy for you to compute Standard Effect Sizes does not necessarily
mean that you should (see Pearse et al. 2013).

Calculating null permutations on a dispersion metric makes little
sense, since (by definition; see Pearse et al. 2014) a dispersion
metric \emph{require} the use of a null distribution to be
calculated. There is nothing to stop you doing so, however! The
code makes no attempt to stop you calculating null dissimilarity
metrics, but I am not certain that doing so is a good idea using
this code as I don't know what to do with such null models!

The \code{\link{pez.shape}}, \code{\link{pez.evenness}},
\code{\link{pez.dispersion}}, and \code{\link{pez.dissimilarity}}
wrapper functions go to some trouble to stop you calculating
metrics using inappropriate data (see their notes). These functions
give you access to the underlying code within \code{pez}; there is
nothing I can do to stop you calculating a metric that, in my
opinion, doesn't make any sense. You have been warned :D
}
\examples{
#Setup data
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits)
#Calculate some metrics
generic.metrics(data, c(.mpd, .pse))
#Compare with a trait-based null model (trait.asm)
generic.null(data, c(.mpd, .pse), "trait.asm", permute=10, trait="fish.pref")
#...be patient when running large (e.g., 1000) sets of null simulations
#You can also do this in pieces, giving even more flexibility
observed <- generic.metrics(data, c(.mpd, .pse))
#null <- .metric.null(data, c(.mpd, .pse))
#ses <- .ses(observed, null)
#...this is how everything works within generic.null
#...and, as with everything in pez, all internal functions start with a "."
}
\references{
Kembel S.W. (2009) Disentangling niche and neutral
influences on community assembly: assessing the performance of
community phylogenetic structure tests. Ecology letters, 12(9),
949-960.

Pearse W.D., Jones F.A. & Purvis A. (2013) Barro
Colorado Island's phylogenetic assemblage structure across fine
spatial scales and among clades of different ages. Ecology, 94(12),
2861-2872.
}
\author{
Will Pearse
}
