% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadableTable.R
\name{downloadableTableUI}
\alias{downloadableTableUI}
\title{downloadableTable module UI function}
\usage{
downloadableTableUI(
  id,
  downloadtypes = NULL,
  hovertext = NULL,
  contentHeight = "200px",
  singleSelect = FALSE
)
}
\arguments{
\item{id}{character id for the object}

\item{downloadtypes}{vector of values for data download types}

\item{hovertext}{download button tooltip hover text}

\item{contentHeight}{viewable height of the table (any valid css size value)}

\item{singleSelect}{whether the table should only allow a single row to be
selected at a time (FALSE by default allows multi-select).}
}
\value{
list of downloadFileButton UI and DT datatable
}
\description{
Creates a custom high-functionality table paired with a linked downloadFile
button.  The table has search and highlight functionality, infinite scrolling,
sorting by columns and returns a reactive dataset of selected items.
}
\details{
downloadFile button will be hidden if \code{downloadableTable} parameter \code{downloaddatafxn} or
\code{downloadableTableUI} parameter \code{downloadtypes} is empty
}
\section{Table Features}{

\itemize{
\item Consistent styling of the table
\item downloadFile module button functionality built-in to the table (it will be shown only if downloadtypes is defined)
\item Ability to show different data from the download data
\item Table is automatically fit to the window size with infinite
y-scrolling
\item Table search functionality including highlighting built-in
\item Multi-select built in, including reactive feedback on which table
items are selected
}
}

\section{Example}{

\code{downloadableTableUI("mytableID", c("csv", "tsv"),
"Click Here", "300px")}
}

\section{Notes}{

When there are no rows to download in any of the linked downloaddatafxns the
button will be hidden as there is nothing to download.
}

\section{Shiny Usage}{

Call this function at the place in ui.R where the table should be placed.

Paired with a call to \code{downloadableTable(id, ...)}
in server.R
}

\examples{
if (interactive()) {
 library(shiny)
 library(periscope2)
 shinyApp(ui = fluidPage(fluidRow(column(width = 12,
   downloadableTableUI("object_id1",
                       downloadtypes = c("csv", "tsv"),
                       hovertext     = "Download the data here!",
                       contentHeight = "300px",
                       singleSelect  = FALSE)))),
   server = function(input, output) {
     mydataRowIds <- function(){
       rownames(head(mtcars))[c(2, 5)]
     }
     selectedrows <- downloadableTable(
       id               = "object_id1",
       logger           = "",
       filenameroot     = "mydownload1",
       downloaddatafxns = list(csv = reactiveVal(mtcars), tsv = reactiveVal(mtcars)),
       tabledata        = reactiveVal(mtcars),
       selection        = mydataRowIds,
       table_options    = list(rownames = TRUE,
                            caption  = "This is a great table!"))
     observeEvent(selectedrows(), {
       print(selectedrows())
     })})
}

}
\seealso{
\link[periscope2]{downloadableTable}

\link[periscope2]{downloadFileButton}

\link[periscope2]{logViewerOutput}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadablePlot}
}
