% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_complex.R
\name{ped_complex}
\alias{ped_complex}
\alias{doubleCousins}
\alias{doubleFirstCousins}
\alias{quadHalfFirstCousins}
\alias{fullSibMating}
\alias{halfSibStack}
\alias{halfSibTriangle}
\title{Complex pedigree structures}
\usage{
doubleCousins(
  degree1,
  degree2,
  removal1 = 0,
  removal2 = 0,
  half1 = FALSE,
  half2 = FALSE,
  child = FALSE
)

doubleFirstCousins()

quadHalfFirstCousins()

fullSibMating(n)

halfSibStack(n)

halfSibTriangle(g)
}
\arguments{
\item{degree1, degree2, removal1, removal2}{Nonnegative integers.}

\item{half1, half2}{Logicals, indicating if the fathers (resp. mothers) should
be full or half cousins.}

\item{child}{A logical: Should a child be added to the double cousins?}

\item{n}{A positive integer indicating the number of crossings.}

\item{g}{A positive integer; the number of generations.}
}
\value{
A \code{\link{ped}} object.
}
\description{
Functions for creating a selection of pedigrees that are awkward to construct
from scratch or with the simple structures described in \link{ped_basic}.
}
\details{
The function \code{doubleCousins} returns a pedigree linking two individuals who
are simultaneous paternal and maternal cousins. More precisely, they are:
\itemize{
\item paternal (full or half) cousins of type (\code{degree1}, \code{removal1})
\item maternal (full or half) cousins of type (\code{degree2}, \code{removal2}).
}

For convenience, a wrapper \code{doubleFirstCousins} is provided for the most
common case, double first cousins.

\code{quadHalfFirstCousins} produces a pedigree with quadruple half first cousins.

\code{fullSibMating} crosses full sibs consecutively \code{n} times.

\code{halfSibStack} produces a breeding scheme where the two individuals in the
final generation are simultaneous half k'th cousins, for each \verb{k = 0,...,n-1}.

\code{halfSibTriangle} produces a triangular pedigree in which every pair of
parents are half siblings.
}
\examples{

# Consecutive brother-sister matings.
x = fullSibMating(2)
# plot(x)

# Simultaneous half siblings and half first cousins
x = halfSibStack(2)
# plot(x)

# Double first cousins
x = doubleFirstCousins()
# plot(x)

# Quadruple half first cousins
x = quadHalfFirstCousins()
# plot(x) # Weird plotting behaviour for this pedigree.

# Triangular half-sib pattern
x = halfSibTriangle(4)
# plot(x)

}
\seealso{
\link{ped_basic}
}
