% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prq.R
\name{prq}
\alias{prq}
\title{Profile Boosting for Quantile Regression}
\usage{
prq(
  formula,
  tau = 0.5,
  data,
  subset,
  weights,
  na.action,
  method = "br",
  model = TRUE,
  contrasts = NULL,
  ...,
  stopFun = EBIC,
  keep = NULL,
  maxK = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{See \link{pboost}.}

\item{tau}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{data}{See \link{pboost}.}

\item{subset}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{weights}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{na.action}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{method}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{model}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{contrasts}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{...}{Parameters passed to \link[quantreg:rq]{quantreg::rq}.}

\item{stopFun}{Parameters passed to \link{pboost}.}

\item{keep}{Parameters passed to \link{pboost}.}

\item{maxK}{Parameters passed to \link{pboost}.}

\item{verbose}{Parameters passed to \link{pboost}.}
}
\value{
An \code{rq} model object fitted on the selected features.
}
\description{
\link{prq} inherits the usage of the function \link[quantreg:rq]{quantreg::rq}.
}
\examples{
library(quantreg)
set.seed(2025)
n <- 300
p <- 200
x <- matrix(rnorm(n*p), n)

eta <- drop( x[, 1:3] \%*\% runif(3, 1.0, 1.5) )
y <- eta + (1.0 + x[, 3]) * rnorm(n)
DF <- data.frame(y, x)

tau <- 0.5
prq(y ~ ., tau, DF, verbose=TRUE)

BIC <- function(obj) AIC(obj, k=-1)
prq(y ~ ., tau, DF, stopFun=BIC, verbose=TRUE)

scorerq <- function(object) {
 return(ifelse(object[["y"]] < fitted(object), tau - 1, tau))
}
pboost(y ~ ., DF, rq, scorerq, EBIC, tau=tau, verbose=TRUE)

}
