% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_partial_residuals.R
\name{plot_partial_residuals}
\alias{plot_partial_residuals}
\title{plot_partial_residuals: scatterplot of partial residuals}
\usage{
plot_partial_residuals(x, add_lm = TRUE, quantile = FALSE, probs = 0.02, ...)
}
\arguments{
\item{x}{a partial_residuals objects from \code{partialling_out()}}

\item{add_lm}{if TRUE, a \code{lm} will be plotted}

\item{quantile}{if TRUE, will plot only the mean values of the quantiles of the mean explanatory variable specified by \code{probs}}

\item{probs}{numeric vector of length one that specifies the number of quantiles to be computed if \code{quantile} is TRUE.
by default, 0.02, which will give 50 quantiles.}

\item{...}{Any other \code{tinyplot::plt()} params}
}
\value{
invisibly, x
}
\description{
Function for plotting partial residuals
Uses \code{tinyplot} as backend
}
\examples{
\donttest{library(palmerpenguins)
library(fixest)
model <- feols(bill_length_mm ~ bill_depth_mm | species + island,
               data = penguins)
partial_df <- partialling_out(model, penguins, both = TRUE)
plot_partial_residuals(partial_df)
}
}
