% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_opinion}
\alias{pbdb_opinion}
\title{Get information about a single taxonomic opinion}
\usage{
pbdb_opinion(id, ...)
}
\arguments{
\item{id}{Identifier of the opinion. This parameter is required.}

\item{...}{Arguments passed to the API. See documentation for
accepted parameters at
\url{https://paleobiodb.org/data1.2/opinions/single}. E.g.:
\itemize{
\item \code{vocab}: Set to \code{"pbdb"} to show the complete name of the
variables (by default variables have short 3-letter names).
\item \code{show}: Additional information to be shown along with the basic
record.  Some possible values include:
\itemize{
\item \code{basis}: The basis of the opinion, which can be
"stated with evidence", "stated without evidence", "implied",
or "second hand".
\item \code{entname}: The names of the people who authorized, entered
and modified this record.
\item \code{refattr}: The author(s) and year of publication of the
reference from which the opinion was entered.
}
}}
}
\value{
A data frame with a single taxonomic opinion.
}
\description{
Returns information about a single taxonomic opinion, selected by
identifier.
}
\examples{
\dontrun{
  pbdb_opinion(id = 1000, vocab = "pbdb", show = "full")
}
}
