% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/together_live.R
\name{together_compare_pair_live}
\alias{together_compare_pair_live}
\title{Live Together.ai comparison for a single pair of samples}
\usage{
together_compare_pair_live(
  ID1,
  text1,
  ID2,
  text2,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  tag_prefix = "<BETTER_SAMPLE>",
  tag_suffix = "</BETTER_SAMPLE>",
  api_key = NULL,
  include_raw = FALSE,
  ...
)
}
\arguments{
\item{ID1}{Character ID for the first sample.}

\item{text1}{Character string containing the first sample's text.}

\item{ID2}{Character ID for the second sample.}

\item{text2}{Character string containing the second sample's text.}

\item{model}{Together.ai model name (for example
\code{"deepseek-ai/DeepSeek-R1"}, \code{"moonshotai/Kimi-K2-Instruct-0905"},
\code{"Qwen/Qwen3-235B-A22B-Instruct-2507-tput"},
\code{"deepseek-ai/DeepSeek-V3"}).}

\item{trait_name}{Short label for the trait (for example "Overall Quality").}

\item{trait_description}{Full-text definition of the trait.}

\item{prompt_template}{Prompt template string, typically from
\code{\link[=set_prompt_template]{set_prompt_template()}}.}

\item{tag_prefix}{Prefix for the better-sample tag. Defaults to
\code{"<BETTER_SAMPLE>"}.}

\item{tag_suffix}{Suffix for the better-sample tag. Defaults to
\code{"</BETTER_SAMPLE>"}.}

\item{api_key}{Optional Together.ai API key. If \code{NULL} or empty, the helper
falls back to the \code{TOGETHER_API_KEY} environment variable via
\code{.together_api_key()}.}

\item{include_raw}{Logical; if \code{TRUE}, adds a list-column \code{raw_response}
containing the parsed JSON body returned by Together.ai (or \code{NULL} on parse
failure). This is useful for debugging parsing problems.}

\item{...}{Additional Together.ai parameters, typically including
\code{temperature}, \code{top_p}, and provider-specific options. These are passed
through to the JSON request body as top-level fields. If \code{temperature} is
omitted, the function uses backend defaults (0.6 for
\code{"deepseek-ai/DeepSeek-R1"}, 0 for all other models).}
}
\value{
A tibble with one row and columns:
\describe{
\item{custom_id}{ID string of the form \code{"LIVE_<ID1>_vs_<ID2>"}.}
\item{ID1, ID2}{The sample IDs you supplied.}
\item{model}{Model name reported by the API.}
\item{object_type}{API object type, typically \code{"chat.completion"}.}
\item{status_code}{HTTP-style status code (200 if successful).}
\item{error_message}{Error message if something goes wrong; otherwise \code{NA}.}
\item{thoughts}{Internal reasoning text, for example \verb{<think>...</think>}
blocks from models like \code{"deepseek-ai/DeepSeek-R1"}.}
\item{content}{Concatenated visible assistant output (without \verb{<think>}
blocks).}
\item{better_sample}{"SAMPLE_1", "SAMPLE_2", or \code{NA}, based on the
\verb{<BETTER_SAMPLE>} tag.}
\item{better_id}{\code{ID1} if \code{"SAMPLE_1"} is chosen, \code{ID2} if \code{"SAMPLE_2"} is
chosen, otherwise \code{NA}.}
\item{prompt_tokens}{Prompt / input token count (if reported).}
\item{completion_tokens}{Completion / output token count (if reported).}
\item{total_tokens}{Total token count (if reported).}
\item{raw_response}{(Optional) list-column containing the parsed JSON body.}
}
}
\description{
\code{together_compare_pair_live()} sends a single pairwise comparison prompt to
the Together.ai Chat Completions API (\verb{/v1/chat/completions}) and parses the
result into a small tibble. It is the Together.ai analogue of
\code{\link[=openai_compare_pair_live]{openai_compare_pair_live()}} and uses the same prompt template and tag
conventions (for example \verb{<BETTER_SAMPLE>...</BETTER_SAMPLE>}).
}
\details{
For models such as \code{"deepseek-ai/DeepSeek-R1"} that emit internal reasoning
wrapped in \verb{<think>...</think>} tags, this helper will:
\itemize{
\item Extract the \verb{<think>...</think>} block into the \code{thoughts} column.
\item Remove the \verb{<think>...</think>} block from the visible \code{content}
column, so \code{content} contains only the user-facing answer.
}

Other Together.ai models (for example \code{"moonshotai/Kimi-K2-Instruct-0905"},
\code{"Qwen/Qwen3-235B-A22B-Instruct-2507-tput"},
\code{"deepseek-ai/DeepSeek-V3"}) are supported via the same API but may not use
\verb{<think>} tags; in those cases, \code{thoughts} will be \code{NA} and the full model
output will appear in \code{content}.

Temperature handling:
\itemize{
\item If \code{temperature} is \strong{not} supplied in \code{...}, the function applies
backend defaults:
\itemize{
\item \code{"deepseek-ai/DeepSeek-R1"} → \code{temperature = 0.6}.
\item All other models → \code{temperature = 0}.
}
\item If \code{temperature} is included in \code{...}, that value is used and the
defaults are not applied.
}
}
\examples{
\dontrun{
# Requires TOGETHER_API_KEY set in your environment and network access.

data("example_writing_samples", package = "pairwiseLLM")
samples <- example_writing_samples[1:2, ]

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

# Example: DeepSeek-R1 with default temperature = 0.6 if not supplied
res_deepseek <- together_compare_pair_live(
  ID1               = samples$ID[1],
  text1             = samples$text[1],
  ID2               = samples$ID[2],
  text2             = samples$text[2],
  model             = "deepseek-ai/DeepSeek-R1",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl
)

res_deepseek$better_id
res_deepseek$thoughts

# Example: Kimi-K2 with default temperature = 0 unless overridden
res_kimi <- together_compare_pair_live(
  ID1               = samples$ID[1],
  text1             = samples$text[1],
  ID2               = samples$ID[2],
  text2             = samples$text[2],
  model             = "moonshotai/Kimi-K2-Instruct-0905",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl
)

res_kimi$better_id
}

}
