% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/together_live.R
\name{submit_together_pairs_live}
\alias{submit_together_pairs_live}
\title{Live Together.ai comparisons for a tibble of pairs}
\usage{
submit_together_pairs_live(
  pairs,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  api_key = NULL,
  verbose = TRUE,
  status_every = 1,
  progress = TRUE,
  include_raw = FALSE,
  ...
)
}
\arguments{
\item{pairs}{Tibble or data frame with at least columns \code{ID1}, \code{text1},
\code{ID2}, \code{text2}. Typically created by \code{\link[=make_pairs]{make_pairs()}}, \code{\link[=sample_pairs]{sample_pairs()}}, and
\code{\link[=randomize_pair_order]{randomize_pair_order()}}.}

\item{model}{Together.ai model name, for example \code{"deepseek-ai/DeepSeek-R1"},
\code{"moonshotai/Kimi-K2-Instruct-0905"},
\code{"Qwen/Qwen3-235B-A22B-Instruct-2507-tput"},
\code{"deepseek-ai/DeepSeek-V3"}.}

\item{trait_name}{Trait name to pass to \code{\link[=together_compare_pair_live]{together_compare_pair_live()}}.}

\item{trait_description}{Trait description to pass to
\code{\link[=together_compare_pair_live]{together_compare_pair_live()}}.}

\item{prompt_template}{Prompt template string, typically from
\code{\link[=set_prompt_template]{set_prompt_template()}}.}

\item{api_key}{Optional Together.ai API key. If \code{NULL} or empty, falls back
to \code{TOGETHER_API_KEY} via \code{.together_api_key()}.}

\item{verbose}{Logical; if \code{TRUE}, prints status, timing, and result
summaries.}

\item{status_every}{Integer; print status / timing for every
\code{status_every}-th pair. Defaults to 1 (every pair). Errors are always
printed.}

\item{progress}{Logical; if \code{TRUE}, shows a textual progress bar.}

\item{include_raw}{Logical; if \code{TRUE}, each row of the returned tibble will
include a \code{raw_response} list-column with the parsed JSON body from
Together.ai.}

\item{...}{Additional Together.ai parameters, such as \code{temperature}, \code{top_p},
or other provider-specific options. These are forwarded to
\code{\link[=together_compare_pair_live]{together_compare_pair_live()}}.}
}
\value{
A tibble with one row per pair and the same columns as
\code{\link[=together_compare_pair_live]{together_compare_pair_live()}}.
}
\description{
\code{submit_together_pairs_live()} is a thin row-wise wrapper around
\code{\link[=together_compare_pair_live]{together_compare_pair_live()}}. It takes a tibble of pairs (\code{ID1}, \code{text1},
\code{ID2}, \code{text2}), submits each pair to the Together.ai Chat Completions API,
and binds the results into a single tibble.
}
\details{
The output has the same columns as \code{\link[=together_compare_pair_live]{together_compare_pair_live()}}, with one
row per pair, making it easy to pass into \code{\link[=build_bt_data]{build_bt_data()}} and
\code{\link[=fit_bt_model]{fit_bt_model()}}.
}
\examples{
\dontrun{
# Requires TOGETHER_API_KEY and network access.

data("example_writing_samples", package = "pairwiseLLM")

pairs <- example_writing_samples |>
  make_pairs() |>
  sample_pairs(n_pairs = 5, seed = 123) |>
  randomize_pair_order(seed = 456)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

# Live comparisons for multiple pairs using DeepSeek-R1
res_live <- submit_together_pairs_live(
  pairs             = pairs,
  model             = "deepseek-ai/DeepSeek-R1",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  temperature       = 0.6,
  verbose           = TRUE,
  status_every      = 2,
  progress          = TRUE,
  include_raw       = FALSE
)

res_live$better_id
}

}
