% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt_template.R
\name{register_prompt_template}
\alias{register_prompt_template}
\title{Register a named prompt template}
\usage{
register_prompt_template(name, template = NULL, file = NULL, overwrite = FALSE)
}
\arguments{
\item{name}{Character scalar; name under which to store the template.}

\item{template}{Optional character string containing a custom template.
If \code{NULL}, the template is read from \code{file}, or the
package default is used when both \code{template} and \code{file}
are \code{NULL}.}

\item{file}{Optional path to a text file containing a template.
Ignored if \code{template} is not \code{NULL}.}

\item{overwrite}{Logical; if \code{FALSE} (default), an error is
thrown when \code{name} already exists in the registry.}
}
\value{
Invisibly, the validated template string.
}
\description{
This function validates a template (or reads it from a file) and
stores it under a user-provided name for reuse in the current R
session. Registered templates live in a package-internal registry.
}
\details{
To make templates persistent across sessions, call this function
in your \code{.Rprofile} or in a project startup script.

Any template must contain the placeholders
\code{{TRAIT_NAME}}, \code{{TRAIT_DESCRIPTION}},
\code{{SAMPLE_1}}, and \code{{SAMPLE_2}}.
}
\examples{
# Register a custom template for this session
custom <- "
You are an expert writing assessor for {TRAIT_NAME}.

{TRAIT_NAME} is defined as {TRAIT_DESCRIPTION}.

Which of the samples below is better on {TRAIT_NAME}?

SAMPLE 1:
{SAMPLE_1}

SAMPLE 2:
{SAMPLE_2}

<BETTER_SAMPLE>SAMPLE_1</BETTER_SAMPLE> or
<BETTER_SAMPLE>SAMPLE_2</BETTER_SAMPLE>
"

register_prompt_template("my_custom", template = custom)

# Retrieve and inspect it
tmpl <- get_prompt_template("my_custom")
cat(substr(tmpl, 1, 160), "...\n")

}
