% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import.R
\name{read_samples_dir}
\alias{read_samples_dir}
\title{Read writing samples from a directory of .txt files}
\usage{
read_samples_dir(path = ".", pattern = "\\\\.txt$")
}
\arguments{
\item{path}{Directory containing .txt files.}

\item{pattern}{A regular expression used to match file names.
Defaults to \code{"\\\\.txt$"}, meaning all files ending in \code{.txt}.}
}
\value{
A tibble with columns:
\itemize{
\item \code{ID}: filename without extension
\item \code{text}: file contents as a single character string
}
}
\description{
This function reads all text files in a directory and uses the
filename (without extension) as the sample ID and the file contents
as the text.
}
\examples{
\dontrun{
# Suppose the working directory contains S1.txt and S2.txt
samples <- read_samples_dir(path = ".", pattern = "\\\\\\\\.txt$")
samples
}

}
