% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_elements.R
\name{osm_update_object}
\alias{osm_update_object}
\title{Update an OSM object}
\usage{
osm_update_object(x, changeset_id)
}
\arguments{
\item{x}{The new object data. Can be the path of an xml file, a \link[xml2:oldclass]{xml2::xml_document} or a data.frame inheriting
or following the structure of an \code{osmapi_objects} object.}

\item{changeset_id}{The ID of an open changeset where to create the object. If missing, \code{x} should define the
changeset ID, otherwise it will be overwritten with \code{changeset_id}. Ignored if \code{x} is a path.}
}
\value{
Returns the new version number of the object.
}
\description{
Updates data from a preexisting element.
}
\details{
A full representation of the element as it should be after the update has to be provided. Any tags, way-node refs,
and relation members that remain unchanged must be in the update as well. A version number must be provided as well,
it \strong{must match} the current version of the element in the database.

If \code{x} is a data.frame, the columns \code{type}, \code{id}, \code{visible}, \code{version}, \code{changeset}, and \code{tags} must be present +
column \code{members} for ways and relations + \code{lat} and \code{lon} for nodes. For the xml format, see the
\href{https://wiki.openstreetmap.org/wiki/API_v0.6#Update:_PUT_/api/0.6/\%5Bnode\%7Cway\%7Crelation\%5D/\%23id}{OSM wiki}.

If multiple elements are provided only the first is updated. The rest is discarded.
}
\note{
\itemize{
\item This updates the bounding box of the changeset.
\item To avoid performance issues when updating multiple objects, the use of the \code{\link[=osm_diff_upload_changeset]{osm_diff_upload_changeset()}} is highly
recommended. This is also the only way to ensure that multiple objects are updated in a single database
transaction.
\itemize{
\item If you can't use the \code{\link[=osm_diff_upload_changeset]{osm_diff_upload_changeset()}} and plan to update more items, mind to do it sequentially (not
in parallel).
}
}
}
\examples{
vignette("how_to_edit_osm", package = "osmapiR")
}
\seealso{
Other edit OSM objects' functions: 
\code{\link{osm_create_object}()},
\code{\link{osm_delete_object}()}
}
\concept{edit OSM objects' functions}
