% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_map_notes.R
\name{osm_feed_notes}
\alias{osm_feed_notes}
\title{RSS Feed of notes in a bbox}
\usage{
osm_feed_notes(bbox)
}
\arguments{
\item{bbox}{Coordinates for the area to retrieve the notes from (\verb{left,bottom,right,top}). Floating point numbers in
degrees, expressing a valid bounding box, not larger than the configured size limit, 25 square degrees (see
\code{osm_capabilities()$note_area} and
\href{https://github.com/openstreetmap/openstreetmap-website/blob/master/config/settings.yml#L27}{this line in settings}
for the current value), not overlapping the dateline. It can be specified by a character, matrix, vector, \code{bbox}
object from \pkg{sf}, a \code{SpatExtent} from \pkg{terra}. Unnamed vectors and matrices will be sorted appropriately
and must merely be in the order (\code{x}, \code{y}, \code{x}, \code{y}) or \code{x} in the first column and \code{y} in the second column.}
}
\value{
Returns a \link[xml2:oldclass]{xml2::xml_document} in the \code{RSS} format.
}
\description{
RSS Feed of notes in a bbox
}
\examples{
feed_notes <- osm_feed_notes(bbox = c(0.8205414, 40.6686604, 0.8857727, 40.7493377))
## bbox as a character value also works (bbox = "0.8205414,40.6686604,0.8857727,40.7493377").
feed_notes
}
\seealso{
Other get notes' functions: 
\code{\link{osm_get_notes}()},
\code{\link{osm_read_bbox_notes}()},
\code{\link{osm_search_notes}()}
}
\concept{get notes' functions}
