% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{list_bng}
\alias{list_bng}
\alias{list_bng_prefixes}
\alias{list_bng_bounds}
\title{List the components of the British National Grid}
\usage{
list_bng_prefixes(arranged = FALSE)

list_bng_bounds(named = TRUE)
}
\arguments{
\item{arranged}{logical. Should the grid reference letters be arranged into a
2D matrix? Default is \code{FALSE}.}

\item{named}{logical. Should the bounding box vector include the names (e.g.
'xmin')? Default is \code{TRUE}.}
}
\value{
a character vector of 2-letter identifiers for all valid 100km grid
squares. When \code{arranged} is \code{TRUE} this vector is coerced into a
2D matrix.

a numeric vector with four values for the xmin, ymin, xmax, and ymax
coordinates for the valid extant of the British National Grid.
}
\description{
Helper functions to provide access to the bounds and set of 100km grid
reference identifiers.
}
\details{
When \code{arranged} is \code{TRUE}, the matrix arrangement matches the
British National Grid, but note the orientation. The first element "SV" would
be mapped in the southwest corner.
}
\examples{
list_bng_prefixes()

list_bng_prefixes(arranged = TRUE)

list_bng_bounds()

}
