% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{plot_lipid_data_summary}
\alias{plot_lipid_data_summary}
\title{Plot and Analyze Lipid Class Data}
\usage{
plot_lipid_data_summary(
  file_path,
  output_xlsx = "lipid_classes_with_names.xlsx",
  missing_plot_path = "missing_values_plot.png",
  rsd_plot_path = "rsd_values_plot.png",
  is_plots_dir = "is_plots",
  blank_pattern = "Blank|Control|Neg",
  pooled_pattern = "Pooled QC|Pooled|Pool|PQ",
  nist_pattern = "NIST Plasma|NIST|nist"
)
}
\arguments{
\item{file_path}{The path to the lipid measurement data file (e.g., "area.txt").}

\item{output_xlsx}{Path to save the lipid classes with names as an Excel file. Default is "lipid_classes_with_names.xlsx".}

\item{missing_plot_path}{Path to save the missing data percentage plot. Default is "missing_values_plot.png".}

\item{rsd_plot_path}{Path to save the RSD percentage plot. Default is "rsd_values_plot.png".}

\item{is_plots_dir}{Directory to save internal standard distribution plots. Default is "is_plots".}

\item{blank_pattern}{Regex pattern to identify blank samples in the "Sample ID" column. Default is "Blank|blank".}

\item{pooled_pattern}{Regex pattern to identify pooled QC samples in the "Sample ID" column. Default is "Pooled QC|Pooled|pool|PQC".}

\item{nist_pattern}{Regex pattern to identify NIST QC samples in the "Sample ID" column. Default is "NIST Plasma|NIST|nist".}
}
\value{
Plots and saves summary figures of missing percentages, RSD percentages, and internal standard distributions.
}
\description{
This function loads a specified data file containing lipid measurements, calculates the summary of missing values and relative standard deviation (RSD) for each lipid class, and generates plots for both summaries. It also plots and saves figures showing the distribution of internal standards across samples.
}
\author{
Yaoxiang Li
}
