.onAttach <- function(libname, pkgname) {
  packageStartupMessage(paste0(
    "\nThis is omicsTools version ",
    utils::packageVersion("omicsTools"),
    ".\nomicsTools is free software and comes with ABSOLUTELY NO WARRANTY",
    ".\nPlease use at your own risk."
  ))
}

# Declare globals used in NSE contexts to satisfy R CMD check
utils::globalVariables(c(
  ".", ".metric", "Adducts", "Area", "Area / Height", "Area Ratio",
  "Asymmetry Factor", "Common_name", "Component Group Name",
  "Component Index", "Component Name", "Component Type",
  "Cooks_Distance", "Cooks_Distance_Flag", "Dilution Factor",
  "End Time", "Expected RT", "FDR", "Feature", "Flag", "Fragment Mass",
  "GO Term", "Gene Number", "Gene Ratio", "Height", "Height Ratio", "IS",
  "IS Area", "IS Area / Height", "IS End Time", "IS Expected RT",
  "IS Height", "IS Name", "IS Quality", "IS Retention Time",
  "IS Signal / Noise", "IS Start Time", "IS Total Width",
  "IS Width at 50%", "Importance", "Injection Volume", "Kurtosis",
  "Kurtosis_Flag", "LOF", "LOF_Flag", "Lipid_Class", "MID", "Mean",
  "Method", "MetlinMass", "Missing_Percentage", "Modified",
  "Outlier Reasons", "Points Across Baseline", "Points Across Half Height",
  "Polarity", "Precursor Mass", "Quality", "QueryMZ", "RSD_Percentage",
  "Relative RT", "Retention Time", "Retention Time Delta (min)",
  "Retention Time Error (%)", "Sample", "Sample ID", "Sample Index",
  "Sample Name", "Sample Type", "Shapiro_p", "Shapiro_p_Flag", "Sign",
  "Signal / Noise", "Skewness", "Skewness_Flag", "Standard Deviation",
  "Start Time", "Tailing Factor", "Total Width", "Used", "Variable",
  "Vial Number", "Width at 50%", "acq_seq", "annotation_data", "area",
  "area_ratio", "component_name", "component_type", "conc", "fwhm",
  "group", "height", "height_ratio", "is_istd", "istd", "istd_area",
  "istd_fwhm", "istd_height", "istd_peak_quality", "istd_peak_width",
  "istd_rt_end", "istd_rt_start", "istd_signal_noise", "label", "log2FC",
  "name", "peak_quality", "peak_width", "percent", "polarity",
  "precursor_mz", "product_mz", "response", "retention_time",
  "retention_time_istd", "rt_end", "rt_start", "sample_id",
  "signal_noise", "std_err", "type"
))
