% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initsControl.R
\name{initsControl}
\alias{initsControl}
\title{Create full control list for initial parameter estimation}
\usage{
initsControl(
  ss.control = ss_control(),
  pooled.control = pooled_control(),
  nca.control = nca_control(),
  fallback.control = fallback_control(),
  selmetrics = "rRMSE2",
  hybrid.base = TRUE,
  preferNCA = TRUE
)
}
\arguments{
\item{ss.control}{A control list consistent with the structure returned by
ss_control().}

\item{pooled.control}{A control list consistent with the structure returned
by pooled_control().}

\item{nca.control}{A control list consistent with the structure returned by
nca_control().}

\item{fallback.control}{A control list consistent with the structure
returned by fallback_control().}

\item{selmetrics}{A character string or vector specifying model performance
metrics to evaluate. Must be one or more of "APE", "MAE", "MAPE", "RMSE",
"rRMSE1", or "rRMSE2". Default is "rRMSE2".}

\item{hybrid.base}{Logical. If TRUE, enables hybrid evaluation mode in which
model performance is assessed using mixed parameter combinations across
methods. If FALSE, each method is evaluated independently. Default is TRUE.}

\item{preferNCA}{Logical. If TRUE and selmetrics equals "rRMSE2", the lowest
rRMSE2 is selected first. If the best-performing method is not NCA-based,
the function then checks whether an NCA-based method offers a lower rRMSE1.
If so, the NCA method is selected. Default is TRUE.}
}
\value{
A named list combining all control modules for parameter estimation.
}
\description{
Aggregates modular control functions into a structured list for use in
population pharmacokinetic parameter initialization.
}
\examples{
initsControl(
  pooled.control = pooled_control(nbins = 8),
  fallback.control = fallback_control(
    sigma_method_additive = "fixed_fraction"
  )
)

}
\seealso{
\link{ss_control}, \link{pooled_control}, \link{nca_control},
\link{fallback_control}
}
