% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{flag_is_rush}
\alias{flag_is_rush}
\title{Flag if the shot attempt is a rush attempt or not for all the shots in a
play-by-play}
\usage{
flag_is_rush(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=flag_is_home]{flag_is_home()}} and
\code{\link[=strip_time_period]{strip_time_period()}} had already been called}
}
\value{
data.frame with one row per event (play) and added \code{isRush} column
}
\description{
\code{flag_is_rush()} flags if the shot attempt is a rush attempt or not for all
the shots in a play-by-play.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                      <- gc_play_by_play()
  test_is_home_flagged      <- flag_is_home(test)
  test_game_id_stripped     <- strip_game_id(test_is_home_flagged)
  test_time_period_stripped <- strip_time_period(test_game_id_stripped)
  test_is_rush_flagged      <- flag_is_rush(test_time_period_stripped)
}
}
