% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{pairs.brmcoda}
\alias{pairs.brmcoda}
\title{Create a matrix of output plots from a \code{\link{brmcoda}}'s \code{\link[brms:brmsfit]{brmsfit}} object}
\usage{
\method{pairs}{brmcoda}(x, ...)
}
\arguments{
\item{x}{A \code{brmcoda} class object.}

\item{...}{Further arguments passed to \code{\link[brms:pairs.brmsfit]{pairs.brmsfit}}.}
}
\description{
A \code{\link[graphics:pairs]{pairs}}
method that is customized for MCMC output.
}
\examples{
\dontrun{
cilr <- complr(data = mcompd, sbp = sbp,
        parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID")

# model with compositional predictor at between and within-person levels
fit <- brmcoda(complr = cilr,
                formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                   wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
               chain = 1, iter = 500)
pairs(fit)
}
}
\seealso{
\code{\link[brms:pairs.brmsfit]{pairs.brmsfit}}
}
