% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{bayes_factor}
\alias{bayes_factor}
\title{S3 method for class 'bayes_factor.bmult'}
\usage{
bayes_factor(x)
}
\arguments{
\item{x}{object of class \code{bmult} as returned from \code{\link{mult_bf_informed}} or \code{\link{binom_bf_informed}}
or an object of class \code{bmult_bridge} as returned from \code{\link{mult_bf_inequality}} or \code{\link{binom_bf_inequality}}}
}
\value{
Returns \code{list} with three \code{data.frames}. The first dataframe \code{bf_table} summarizes information
the Bayes factor for equality and inequality constraints. The second dataframe \code{error_measures} contains for the overall Bayes factor
the approximate relative mean-squared error \code{re2}, the approximate coefficient of variation \code{cv}, and the approximate percentage error \code{percentage}.
The third dataframe \code{$bf_ineq_table} summarized
information about the Bayes factor for inequality constraints, that is, the log marginal likelihood estimates
for the constrained prior and posterior distribution. In addition, it contains for each independent Bayes factor
the approximate relative mean-squared error \code{re2}
}
\description{
Extracts information about computed Bayes factors from object of class \code{bmult}
}
\note{
In case the restricted hypothesis is tested against \eqn{H_0} four \code{data.frame}s will be returned.
The fourth dataframe \code{$bf_eq_table} summarizes information about the Bayes factor for equality constraints compared to the encompassing
hypothesis.
}
\examples{
# data
x <- c(3, 4, 10, 11)
n <- c(15, 12, 12, 12)
# priors
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
# informed hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4')
Hr            <- c('theta1', '<',  'theta2', '<', 'theta3', '<', 'theta4')

## Multinomial Case
out_mult  <- mult_bf_informed(x=x, Hr=Hr, a=a, factor_levels=factor_levels,
niter=500, seed=2020)
bayes_factor(out_mult)
}
