% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{Chip}
\alias{Chip}
\title{Chip}
\usage{
Chip(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/chip/}
}
\details{
\itemize{
\item avatar \code{element} \cr Default is - The Avatar element to display.
\item children \code{unsupportedProp} \cr Default is - This prop isn't supported. Use the component prop if you need to change the children structure.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item clickable \code{bool} \cr Default is - If true, the chip will appear clickable, and will raise when pressed, even if the onClick prop is not defined. If false, the chip will not appear clickable, even if onClick prop is defined. This can be used, for example, along with the component prop to indicate an anchor Chip is clickable. Note: this controls the UI and does not affect the onClick event.
\item color \code{'default'| 'primary'| 'secondary'| 'error'| 'info'| 'success'| 'warning'| string} \cr Default is 'default' The color of the component. It supports both default and custom theme colors, which can be added as shown in the palette customization guide.
\item component \code{elementType} \cr Default is - The component used for the root node. Either a string to use a HTML element or a component.
\item deleteIcon \code{element} \cr Default is - Override the default delete icon element. Shown only if onDelete is set.
\item disabled \code{bool} \cr Default is FALSE If true, the component is disabled.
\item icon \code{element} \cr Default is - Icon element.
\item label \code{node} \cr Default is - The content of the component.
\item onDelete \code{func} \cr Default is - Callback fired when the delete icon is clicked. If set, the delete icon will be shown.
\item size \code{'medium'| 'small'| string} \cr Default is 'medium' The size of the component.
\item skipFocusWhenDisabled \code{bool} \cr Default is FALSE If true, allows the disabled chip to escape focus. If false, allows the disabled chip to receive focus.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item variant \code{'filled'| 'outlined'| string} \cr Default is 'filled' The variant to use.
}
}
