% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_functions.R
\name{unpack_sensor_data}
\alias{unpack_sensor_data}
\title{Unpack raw sensor data}
\usage{
unpack_sensor_data(data, ...)
}
\arguments{
\item{data}{A data frame containing the raw sensor data.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A data frame with the sensor data unpacked.
}
\description{
This function takes raw sensor data coming from \code{\link[=import]{import()}} and unpacks it into tidy data frames
so that it can be written to the database. Note that this function is internal and should not
be used for other purposes.
}
\examples{
x <- tibble::tibble(
  study_id = "test-study",
  participant_id = "12345",
  data_format = "cams 1.0.0",
  start_time = "2021-11-14 16:40:00.123456",
  end_time = NULL,
  sensor = "Activity",
  data = list(list(
    confidence = 80,
    type = "WALKING"
  ))
)
class(x) <- c("activity", class(x))
mpathsenser:::unpack_sensor_data(x)
}
\keyword{internal}
